/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.supportconsole.resources.AbstractRestSupportConsoleResource;
import com.comalatech.confluence.workflow.supportconsole.service.SupportConsoleService;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.nio.file.Files;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/support/")
public class SupportConsoleResource
extends AbstractRestSupportConsoleResource {
    private static final Logger log = LoggerFactory.getLogger(SupportConsoleResource.class);
    private final SupportConsoleService supportConsoleService;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;

    public SupportConsoleResource(SupportConsoleService supportConsoleService, @ComponentImport SpaceManager spaceManager, WorkflowsFeatureManager workflowsFeatureManager, @ComponentImport PermissionManager permissionManager, @ComponentImport PageManager pageManager) {
        super(permissionManager, workflowsFeatureManager, spaceManager);
        this.supportConsoleService = supportConsoleService;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
    }

    @ReadOnlyAccessAllowed
    @GET
    @Path(value="/{spaceKey}")
    @PermissionRequired(value={"ADMINISTER"})
    @Produces(value={"application/octet-stream"})
    @ApiResponses(value={@ApiResponse(code=200, message="Support file is generated and returned"), @ApiResponse(code=403, message="User is not administrator"), @ApiResponse(code=400, message="Space key is null or does not exists"), @ApiResponse(code=500, message="Cannot generate support data")})
    public Response getSupportFile(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="pageId") String pageId, final @QueryParam(value="storageFormat") boolean hasStorageFormat) {
        final Space space = this.spaceManager.getSpace(spaceKey);
        final AbstractPage page = this.getPageFromParameter(pageId);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (StringUtils.isNotBlank((CharSequence)pageId) && page == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return new AbstractRestSupportConsoleResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    java.nio.file.Path supportFile = SupportConsoleResource.this.supportConsoleService.getSupportFile(space, page, hasStorageFormat);
                    StreamingOutput stream = outputStream -> Files.copy(supportFile, outputStream);
                    return Response.ok((Object)stream, (String)"application/octet-stream").header("Content-Length", (Object)String.valueOf(Files.size(supportFile))).header("Content-Disposition", (Object)("attachment; filename=" + supportFile.getFileName().toString())).build();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", e.getMessage() != null ? StringEscapeUtils.escapeHtml4((String)e.getMessage()) : "Internal server error");
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    private AbstractPage getPageFromParameter(String pageIdAsString) {
        long pageId = NumberUtils.toLong((String)pageIdAsString);
        if (pageId == 0L) {
            return null;
        }
        return this.pageManager.getAbstractPage(pageId);
    }
}

