/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.stats;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowStatisticsManager
implements WorkflowStatisticsManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowStatisticsManager.class);
    protected static final String STATS_BANDANA_KEY = "workflow.stats.enabled";
    protected static final String MIGRATION_ASSESSMENT_BANDANA_KEY = "workflow.migration.assessment.enabled";
    protected final BandanaManager bandanaManager;
    protected Map<String, String> systemStats;

    public DefaultWorkflowStatisticsManager(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        this.systemStats = new HashMap<String, String>();
    }

    @Override
    public void enableStats(boolean enable) {
        this.bandanaManager.setValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, STATS_BANDANA_KEY, (Object)Boolean.valueOf(enable).toString());
    }

    @Override
    public boolean isStatsEnabled() {
        Object value = this.bandanaManager.getValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, STATS_BANDANA_KEY);
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return true;
    }

    @Override
    public void enableMigrationAssessment(boolean enable) {
        this.bandanaManager.setValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, MIGRATION_ASSESSMENT_BANDANA_KEY, (Object)Boolean.valueOf(enable).toString());
    }

    @Override
    public boolean isMigrationAssessmentEnabled() {
        Object value = this.bandanaManager.getValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, MIGRATION_ASSESSMENT_BANDANA_KEY);
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return this.isStatsEnabled();
    }

    @Override
    public void pushSystemStats(Map<String, String> statFields) {
        this.systemStats = statFields;
    }

    @Override
    public Map<String, String> popSystemStats() {
        Map<String, String> returnStats = this.systemStats;
        if (!this.systemStats.isEmpty()) {
            this.systemStats = new HashMap<String, String>();
            if (log.isDebugEnabled()) {
                log.debug("pop workflow stats: " + returnStats);
            }
        }
        return returnStats;
    }
}

