/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RiojaUIServlet
extends HttpServlet {
    private static final String RESOURCE = "resource";
    private final TemplateRenderer renderer;
    private WorkflowsFeatureManager featureManager;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private String resource;

    public RiojaUIServlet(@ComponentImport TemplateRenderer renderer, WorkflowsFeatureManager featureManager, WorkflowConfigurationManager workflowConfigurationManager) {
        this.renderer = renderer;
        this.featureManager = featureManager;
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void init() {
        this.resource = this.getServletConfig().getInitParameter(RESOURCE);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            Map context = MacroUtils.defaultVelocityContext();
            context.put("resp", response);
            context.put("urlMode", UrlMode.AUTO);
            context.put("scope", Collections.singletonList(this.resource));
            context.put("lang", request.getParameter("loc").substring(0, 2));
            HashMap<String, Object> cml = new HashMap<String, Object>();
            String product = this.featureManager.isApprovalsApp() ? "approvals" : (this.featureManager.isWorkflowsLiteApp() ? "lite" : "cw");
            String pluginKey = this.featureManager.getPluginKey();
            cml.put("cp", request.getContextPath());
            cml.put("plugincp", "/plugins/servlet/workflows/rioja");
            cml.put("isWorkflowsApp", this.featureManager.isWorkflowsApp());
            cml.put("isWorkflowsLiteApp", this.featureManager.isWorkflowsLiteApp());
            cml.put("isApprovalsApp", this.featureManager.isApprovalsApp());
            cml.put("product", product);
            cml.put("pluginKey", pluginKey);
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            cml.put("username", user != null ? user.getName() : "");
            cml.put("pluginVersion", this.workflowConfigurationManager.getPluginVersionNumber());
            context.put("CML", cml);
            this.renderer.render("templates/riojaui/remote.vm", context, (Writer)response.getWriter());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

