/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers.documentreport;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.model.UserContentPropertyModel;
import com.comalatech.confluence.tasks.extractor.model.CompletedTasksContentProperty;
import com.comalatech.confluence.tasks.extractor.model.PageTasksContentPropertyModel;
import com.comalatech.confluence.tasks.extractor.model.PendingTasksContentProperty;
import com.comalatech.confluence.workflow.restv2.model.documentreport.TaskReport;
import com.comalatech.confluence.workflow.restv2.model.documentreport.TaskReportData;
import com.comalatech.confluence.workflow.restv2.model.documentreport.WorkflowsReportData;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.DocumentReportJsonPropertyMapper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasksMapper
implements DocumentReportJsonPropertyMapper {
    private static final Logger log = LoggerFactory.getLogger(TasksMapper.class);
    private static final String KEY = "comalaworkflowstasks";
    private final UserAccessor userAccessor;
    private static final ObjectMapper mapper = new ObjectMapper();

    public TasksMapper(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public WorkflowsReportData map(String key, String json, WorkflowsReportData workflowReportData) {
        if (workflowReportData == null) {
            workflowReportData = new WorkflowsReportData();
        }
        if (KEY.equalsIgnoreCase(key)) {
            try {
                PageTasksContentPropertyModel pageTasksContentPropertyModel = (PageTasksContentPropertyModel)mapper.readValue(json, PageTasksContentPropertyModel.class);
                TaskReportData taskReportData = TaskReportData.builder().pendingTasks(this.mapPendingTaskPropertyModel(pageTasksContentPropertyModel.getPendingTasksContentProperties())).completedTasks(this.mapCompletedTaskPropertyModel(pageTasksContentPropertyModel.getCompletedTasksContentProperties())).build();
                workflowReportData.setTaskReportData(taskReportData);
            }
            catch (Exception e) {
                log.warn("Cannot map {}  to object : {}  ", new Object[]{KEY, json, e});
            }
        }
        return workflowReportData;
    }

    private List<TaskReport> mapPendingTaskPropertyModel(List<PendingTasksContentProperty> pendingTasksContentProperties) {
        return pendingTasksContentProperties.stream().map(pendingTasksContentProperty -> TaskReport.builder().id(pendingTasksContentProperty.getId()).name(pendingTasksContentProperty.getName()).note(pendingTasksContentProperty.getNote()).assignedTo(this.mapUser(pendingTasksContentProperty.getAssignedTo())).assignedBy(this.mapUser(pendingTasksContentProperty.getAssignedBy())).assignmentDate(pendingTasksContentProperty.getAssignmentDate()).dueDate(pendingTasksContentProperty.getDueDate()).timeSpent(this.calculateTimeSpent(pendingTasksContentProperty.getAssignmentDate())).build()).collect(Collectors.toList());
    }

    private long calculateTimeSpent(long assignmentDate) {
        if (assignmentDate == 0L) {
            return 0L;
        }
        return new Date().toInstant().toEpochMilli() - assignmentDate;
    }

    private UserContentPropertyModel mapUser(String user) {
        ConfluenceUser confUser = this.userAccessor.getUserByName(user);
        if (Objects.isNull(confUser)) {
            return null;
        }
        ProfilePictureInfo userProfilePicture = this.getUserProfilePicture(confUser);
        String path = Objects.nonNull(userProfilePicture) ? userProfilePicture.getUriReference() : null;
        return new UserContentPropertyModel(confUser.getName(), confUser.getFullName(), path, confUser.getKey().getStringValue(), true);
    }

    private ProfilePictureInfo getUserProfilePicture(ConfluenceUser confUser) {
        return this.userAccessor.getUserProfilePicture((User)confUser);
    }

    private List<TaskReport> mapCompletedTaskPropertyModel(List<CompletedTasksContentProperty> completedTasksContentProperties) {
        return completedTasksContentProperties.stream().map(completedTasksContentProperty -> {
            long timeSpent = 0L;
            if (completedTasksContentProperty.getAssignmentDate() != 0L) {
                timeSpent = completedTasksContentProperty.getCompletionDate() - completedTasksContentProperty.getAssignmentDate();
            }
            return TaskReport.builder().id(completedTasksContentProperty.getId()).name(completedTasksContentProperty.getName()).note(completedTasksContentProperty.getNote()).assignedTo(this.mapUser(completedTasksContentProperty.getAssignedTo())).assignedBy(this.mapUser(completedTasksContentProperty.getAssignedBy())).assignmentDate(completedTasksContentProperty.getAssignmentDate()).dueDate(completedTasksContentProperty.getDueDate()).timeSpent(timeSpent).build();
        }).collect(Collectors.toList());
    }

    static {
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }
}

