/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.comalatech.confluence.workflow.model.WorkflowPageHeader;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflowSection;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;

public class WorkflowSectionMapper
implements Mapper<WorkflowPageHeader, RestWorkflowSection> {
    @Override
    public RestWorkflowSection toRest(WorkflowPageHeader pageHeader) {
        RestWorkflowSection.Visibility visibility = RestWorkflowSection.Visibility.fromString(pageHeader.getVisibility().toString());
        return new RestWorkflowSection(pageHeader.getBody(), visibility);
    }

    @Override
    public WorkflowPageHeader fromRest(RestWorkflowSection restWorkflowSection) {
        return this.fromRest(restWorkflowSection, WorkflowPageHeader.class);
    }

    public <T extends WorkflowPageHeader> T fromRest(RestWorkflowSection restWorkflowSection, Class<? extends WorkflowPageHeader> clazz) {
        try {
            WorkflowPageHeader pageHeader = clazz.newInstance();
            WorkflowPageHeader.Visibility visibility = WorkflowPageHeader.Visibility.parse(restWorkflowSection.visibility.toString());
            pageHeader.setBody(restWorkflowSection.body);
            pageHeader.setVisibility(visibility);
            return (T)pageHeader;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new MapperException("Error instantiating the WorkflowPageHeader|Footer by reflection", ex);
        }
    }
}

