/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.dao.AdhocWorkflowDao;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.rest.accessor.WorkflowMarkupConverter;
import com.comalatech.confluence.workflow.rest.model.WorkflowMarkupResponse;
import com.comalatech.confluence.workflow.rest.resources.AbstractAdminRestResource;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Deprecated
@WorkflowsAppRequired
@Path(value="/markup")
@Produces(value={"application/json"})
public class WorkflowMarkupResource
extends AbstractAdminRestResource {
    private static final Logger log = LoggerFactory.getLogger(WorkflowMarkupResource.class);
    private final WorkflowMarkupConverter workflowMarkupConverter;

    public WorkflowMarkupResource(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @Qualifier(value="workflowTemplateManager") WorkflowTemplateManager workflowTemplateManager, AdhocWorkflowDao adhocWorkflowDao, WorkflowsFeatureManager workflowsFeatureManager, @ComponentImport PageManager pageManager, WorkflowMarkupConverter workflowMarkupConverter) {
        super(permissionManager, spaceManager, workflowTemplateManager, adhocWorkflowDao, workflowsFeatureManager, pageManager);
        this.workflowMarkupConverter = workflowMarkupConverter;
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="/parse")
    @Consumes(value={"text/plain"})
    public Response parse(String markup) {
        try {
            log.debug("Starting REST parse markup service");
            WorkflowMarkupResponse response = this.workflowMarkupConverter.parseWorkflow(markup);
            log.debug("Ended successfully REST parse markup service");
            return Response.ok((Object)response).build();
        }
        catch (WorkflowException e) {
            return Response.status((int)400).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
    }
}

