/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.workflow.rest.model.Approval;
import com.comalatech.confluence.workflow.rest.model.Parameter;
import com.comalatech.workflow.model.PageWorkflowParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.codehaus.jackson.annotate.JsonProperty;

@XmlAccessorType(value=XmlAccessType.FIELD)
@ApiModel(description="Info about a workflow state")
public class State {
    @ApiModelProperty(value="Name of the state", dataType="string", example="Draft")
    public String name;
    @ApiModelProperty(value="State name translation", dataType="string", example="Draft translation")
    public String nameTranslation;
    @ApiModelProperty(value="Description of the state", dataType="string", example="State of pages under construction")
    public String description;
    @ApiModelProperty(value="Available state transitions from this state")
    public StateTransitions transitions;
    @XmlElement(name="final")
    @JsonProperty(value="final")
    @ApiModelProperty(value="True if is a final state", name="final", dataType="string", example="false")
    public Boolean finalState;
    @ApiModelProperty(value="True if tasks can be set in this state", dataType="boolean", example="true")
    public Boolean taskable;
    @ApiModelProperty(value="True if due date can be changed by users", example="false", dataType="boolean")
    public Boolean changeDueDate;
    @ApiModelProperty(value="True if the state is hidden from the workflow progress tracker", dataType="boolean", example="true")
    public Boolean hideFromPath;
    @ApiModelProperty(value="Time period before the state expires (ISO 8601 format) or exact date when the state expires", dataType="string", example="P2D")
    public String dueDate;
    @ApiModelProperty(value="Colour of the state", dataType="string", example="#FFAB00")
    public String colour;
    @ApiModelProperty(value="List of available approvals in this state")
    public List<Approval> approvals;

    public State() {
    }

    public State(com.comalatech.confluence.states.model.State state) {
        this.name = state.getName();
        this.description = state.getDescription();
        this.transitions = new StateTransitions(state);
        if (state.isFinalState()) {
            this.finalState = true;
        }
        if (state.isTaskable()) {
            this.taskable = true;
        }
        if (state.isChangeDueDate()) {
            this.changeDueDate = state.isChangeDueDate();
        }
        if (state.isHideFromPath()) {
            this.hideFromPath = true;
        }
        this.dueDate = state.getDueDate();
        this.colour = state.getColour();
        if (state.getApprovals().size() > 0) {
            this.approvals = new ArrayList<Approval>();
            for (com.comalatech.confluence.workflow.model.Approval approval : state.getApprovals()) {
                this.approvals.add(new Approval(approval));
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ApiModel(description="State transition definition")
    public static class StateTransition {
        @ApiModelProperty(value="State transition", dataType="string")
        public String state;
        @ApiModelProperty
        public List<Parameter> parameters;

        public static StateTransition of(String stateName, Map<String, List<PageWorkflowParameter>> parameters) {
            return StateTransition.of(stateName, parameters != null ? parameters.get(stateName) : null);
        }

        public static StateTransition of(String stateName, List<PageWorkflowParameter> workflowParameters) {
            if (stateName != null) {
                StateTransition transition = new StateTransition();
                transition.state = stateName;
                transition.parameters = workflowParameters != null ? workflowParameters.stream().map(p -> Parameter.of(p)).collect(Collectors.toList()) : null;
                return transition;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateTransition that = (StateTransition)o;
            return Objects.equals(this.state, that.state);
        }

        public int hashCode() {
            return Objects.hash(this.state);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ApiModel(description="State transitions defined for each workflow event")
    public static class StateTransitions {
        @ApiModelProperty(value="Name of the state that will be automatically set when all approvals are approved")
        public StateTransition approved;
        @ApiModelProperty(value="Name of the state that will be automatically set when all approvals are rejected")
        public StateTransition rejected;
        @ApiModelProperty(value="Name of the state that will be automatically set when the page is updated")
        public StateTransition updated;
        @ApiModelProperty(value="Name of the state that will be automatically set when the state expires")
        public StateTransition expired;
        @ApiModelProperty(value="Name of the state that will be automatically set when page is submitted")
        public StateTransition submit;
        @ApiModelProperty(value="Name of the state that will be automatically set when all tasks are completed")
        public StateTransition completed;
        @ApiModelProperty(value="List of names of the states available to be selected as the next state")
        public Set<StateTransition> select;

        public StateTransitions() {
        }

        public StateTransitions(com.comalatech.confluence.states.model.State state) {
            this(state, null);
        }

        public StateTransitions(com.comalatech.confluence.states.model.State state, Map<String, List<PageWorkflowParameter>> parameters) {
            this.approved = StateTransition.of(state.getApprovedStateName(), parameters);
            this.rejected = StateTransition.of(state.getRejectedStateName(), parameters);
            this.updated = StateTransition.of(state.getUpdatedStateName(), parameters);
            this.expired = StateTransition.of(state.getExpiredStateName(), parameters);
            if (state.getSubmitState() != null) {
                this.submit = StateTransition.of(state.getSubmitState().getName(), parameters);
            }
            this.completed = StateTransition.of(state.getCompletedStateName(), parameters);
            this.select = new HashSet<StateTransition>();
            if (state.getStateSelections() != null && state.getStateSelections().size() > 0) {
                for (StateSelection stateSelection : state.getStateSelections()) {
                    for (com.comalatech.confluence.states.model.State option : stateSelection.getAllowedStates()) {
                        StateTransition transition = StateTransition.of(option.getName(), parameters);
                        if (transition == null) continue;
                        this.select.add(transition);
                    }
                }
            }
        }
    }
}

