/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.comalatech.workflow.model.PageWorkflowParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@ApiModel
public class Parameter {
    @ApiModelProperty(dataType="string")
    public String id;
    @ApiModelProperty(dataType="string")
    public String name;
    @ApiModelProperty(dataType="string")
    public String description;
    @ApiModelProperty(dataType="string")
    public String type;
    @ApiModelProperty(dataType="string")
    public String value;
    @ApiModelProperty(dataType="boolean")
    public Boolean isDefault;
    @ApiModelProperty(dataType="boolean")
    public Boolean isFilled;
    @ApiModelProperty
    public List<String> options;

    public static Parameter of(PageWorkflowParameter workflowParameter) {
        if (workflowParameter != null) {
            Parameter parameter = new Parameter();
            parameter.id = workflowParameter.getId();
            parameter.name = workflowParameter.getName();
            parameter.description = workflowParameter.getDescription();
            parameter.type = workflowParameter.getType().getName();
            parameter.value = workflowParameter.getValue();
            parameter.options = workflowParameter.getOptions();
            parameter.isDefault = workflowParameter.isDefault();
            parameter.isFilled = StringUtils.isNotEmpty((CharSequence)parameter.value) && parameter.isDefault == false;
            return parameter;
        }
        return null;
    }
}

