/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.comalatech.confluence.workflow.rest.model.Condition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.comalatech.workflow.model.SignatureType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
@ApiModel(description="State Approvals")
public class Approval {
    @ApiModelProperty(value="Approval Name", dataType="string", example="Review")
    public String name;
    @ApiModelProperty(value="Numeric value that sets in which order the approvals appear in the state (lightest weight first)", dataType="number", example="10")
    public Integer weight;
    @ApiModelProperty(value="Labels that must be present in the page/blog post to make the approval appear", dataType="string", example="label_1")
    public String label;
    @ApiModelProperty(value="Credentials required to approve/reject the approval (if none required, not shown). \"password\" or \"userid+password\".", dataType="string", example="password")
    public String credentials;
    @ApiModelProperty(value="List of automatically assigned approval reviewers when the state is initialized.")
    public Approvers approvers;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Condition.PermissionCondition.class, name="permission"), @JsonSubTypes.Type(value=Condition.MetadataCondition.class, name="metadata"), @JsonSubTypes.Type(value=Condition.StateCondition.class, name="state"), @JsonSubTypes.Type(value=Condition.SpaceCondition.class, name="space"), @JsonSubTypes.Type(value=Condition.PageCondition.class, name="page"), @JsonSubTypes.Type(value=Condition.UserCondition.class, name="user"), @JsonSubTypes.Type(value=Condition.GroupCondition.class, name="group"), @JsonSubTypes.Type(value=Condition.AllowedAssignerUserCondition.class, name="allowedassignusers"), @JsonSubTypes.Type(value=Condition.AllowedAssignerGroupCondition.class, name="allowedassigngroups"), @JsonSubTypes.Type(value=Condition.ExcludeCondition.class, name="exclude"), @JsonSubTypes.Type(value=Condition.HasApprovalCondition.class, name="hasapproval"), @JsonSubTypes.Type(value=Condition.HasLabelCondition.class, name="haslabel")})
    @ApiModelProperty(value="Approval conditions list.")
    public List<Condition> conditions;

    public Approval() {
    }

    public Approval(com.comalatech.confluence.workflow.model.Approval approval) {
        this.name = approval.getName();
        if (approval.getWeight() != 40) {
            this.weight = approval.getWeight();
        }
        if (approval.getLabel() != null) {
            this.label = approval.getLabel().getName();
        }
        if (approval.getCredentials() == SignatureType.PASSWORD) {
            this.credentials = "password";
        } else if (approval.getCredentials() == SignatureType.USERID_AND_PASSWORD) {
            this.credentials = "userid+password";
        }
        this.conditions = new ArrayList<Condition>();
        String assignedUsers = null;
        String assignedGroups = null;
        for (com.comalatech.confluence.workflow.model.Condition condition : approval.getConditions()) {
            SerializableMacro macro = new SerializableMacro("dummy");
            condition.addMacroParameters(macro);
            SerializableMacro.ParsedParameters params = macro.getParameters();
            if (params.has("user") && params.all) {
                assignedUsers = params.value;
                continue;
            }
            if (params.has("group") && params.all) {
                assignedGroups = params.value;
                continue;
            }
            Condition newCondition = Condition.build(params);
            if (newCondition == null) continue;
            this.conditions.add(newCondition);
        }
        this.approvers = this.makeApprovers(approval, assignedUsers, assignedGroups);
        if (this.conditions.size() == 0) {
            this.conditions = null;
        }
    }

    private Approvers makeApprovers(com.comalatech.confluence.workflow.model.Approval approval, String assignedUsers, String assignedGroups) {
        int minimumApprovers;
        try {
            minimumApprovers = Integer.parseInt(approval.getMinRequiredApprovers());
        }
        catch (NumberFormatException e) {
            minimumApprovers = 0;
        }
        String type = minimumApprovers > 1 ? "" + minimumApprovers + "+" : (assignedUsers != null || assignedGroups != null ? "all" : "*");
        return new Approvers(assignedUsers, assignedGroups, type);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ApiModel(description="Information about the default approvers of the approval")
    public static class Approvers {
        @ApiModelProperty(value="Comma separated list of directly assigned approvers", dataType="string", example="user1,user2,user3")
        public String users;
        @ApiModelProperty(value="Comma separated list of directly assigned approver groups", dataType="string", example="confluence-users,confluence-administrators")
        public String groups;
        @ApiModelProperty(value="<p>Minimum required amount of approvers to approve/reject the approval. Possible values:</p><ul><li>If no minimum value is set or minimum is 0 or 1 then it will be \"*\".</li><li>If it is directly assigned using \"&\" before \"user\" and \"group\" its value would be \"all\".</li><li>If there are no directly assigned users or groups and minimum is higher than 1 then its value will be shown like \"{minimum}+\"</li></ul>", dataType="string", example="*")
        public String minimum;

        public Approvers() {
        }

        public Approvers(String users, String groups, String minimum) {
            this.users = users;
            this.groups = groups;
            this.minimum = minimum;
        }
    }
}

