/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.parameter.extractor;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.parameter.extractor.model.WorkflowParameterContentProperty;
import com.comalatech.confluence.workflow.parameter.extractor.model.WorkflowParameterContentPropertyModelVersion;
import com.comalatech.confluence.workflow.parameter.extractor.model.WorkflowParametersContentPropertyModel;
import com.comalatech.workflow.model.WorkflowParameter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowParameterPropertyExtractor {
    private static final Logger log = LoggerFactory.getLogger(WorkflowParameterPropertyExtractor.class);
    private final InternalWorkflowParameterManager workflowParameterManager;
    private final WorkflowAccessor workflowAccessor;
    private final ObjectMapper mapper;

    public WorkflowParameterPropertyExtractor(InternalWorkflowParameterManager workflowParameterManager, WorkflowAccessor workflowAccessor) {
        this.workflowParameterManager = workflowParameterManager;
        this.workflowAccessor = workflowAccessor;
        this.mapper = new ObjectMapper();
        this.mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    public String getJsonOf(AbstractPage page) {
        WorkflowParametersContentPropertyModel data = this.extractFrom(page);
        return this.serialize(data);
    }

    private WorkflowParametersContentPropertyModel extractFrom(AbstractPage page) {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows == null) {
            return null;
        }
        HashSet<WorkflowParameter> workflowParameters = new HashSet<WorkflowParameter>(this.workflowParameterManager.getWorkflowParameters(pageWorkflows));
        HashSet<WorkflowParameterContentProperty> workflowParameterContentProperties = new HashSet<WorkflowParameterContentProperty>(this.extractParameters(workflowParameters));
        WorkflowParametersContentPropertyModel wpModel = new WorkflowParametersContentPropertyModel();
        wpModel.workflowParameters = workflowParameterContentProperties;
        return wpModel;
    }

    public <T> String serialize(T data) {
        try {
            return this.mapper.writeValueAsString(data);
        }
        catch (Exception e) {
            String className = data == null ? "" : data.getClass().getSimpleName();
            log.error(className + " could not be serialized", (Throwable)e);
            return "";
        }
    }

    public String getCurrentWorkflowParameterModelVersionJson() {
        return this.serialize(WorkflowParameterContentPropertyModelVersion.getCurrentVersion());
    }

    public WorkflowParametersContentPropertyModel deserialize(String jsonContentProperty) {
        try {
            return (WorkflowParametersContentPropertyModel)this.mapper.readValue(jsonContentProperty, WorkflowParametersContentPropertyModel.class);
        }
        catch (IOException | NullPointerException e) {
            log.error("Error deserializing task content property {} ", (Object)jsonContentProperty, (Object)e);
            return null;
        }
    }

    private Set<WorkflowParameterContentProperty> extractParameters(Set<WorkflowParameter> workflowParameters) {
        if (workflowParameters != null) {
            return workflowParameters.stream().map(WorkflowParameterContentProperty::fromParameter).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

