/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.workflow.model.AssignedApprover;
import com.comalatech.workflow.model.SignatureType;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class AssignedApproverImpl
implements AssignedApprover {
    private Approver approver;
    private String assignee;
    private String name;
    private boolean canApprove;
    private boolean canReject;
    private SignatureType signatureType;

    public AssignedApproverImpl(Approver approver, String name, SignatureType signature, boolean canMark) {
        this.name = name;
        this.approver = approver;
        this.canApprove = canMark && !approver.isApproved();
        this.canReject = canMark && approver.isApproved();
        this.signatureType = signature;
    }

    public AssignedApproverImpl(String assignee, String name, SignatureType signature, boolean canMark) {
        this.assignee = assignee;
        this.name = name;
        this.canApprove = canMark;
        this.canReject = canMark;
        this.signatureType = signature;
    }

    @Override
    public boolean canApprove() {
        return this.canApprove;
    }

    @Override
    public boolean canReject() {
        return this.canReject;
    }

    @Override
    public boolean isApproved() {
        return this.approver != null && this.approver.isApproved();
    }

    @Override
    public boolean isRejected() {
        return this.approver != null && !this.approver.isApproved();
    }

    public List<AssignedApprover> getAssignments() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    @Deprecated
    public List<String> getAssigneesUserNames() {
        return Collections.singletonList(this.getUserName());
    }

    @Override
    public String getAssignee() {
        return this.getUserName();
    }

    @Override
    public String getActivityId() {
        return null;
    }

    @Override
    public String getUserName() {
        if (this.approver != null) {
            return this.approver.getUser();
        }
        return this.assignee;
    }

    @Override
    public String getPerformer() {
        return null;
    }

    @Override
    public Date getDate() {
        if (this.approver != null) {
            return this.approver.getDate();
        }
        return null;
    }

    @Override
    public String getComment() {
        if (this.approver != null) {
            return this.approver.getComment();
        }
        return null;
    }

    @Override
    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public void setCanApprove(boolean canApprove) {
        this.canApprove = canApprove;
    }

    public void setCanReject(boolean canReject) {
        this.canReject = canReject;
    }
}

