/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.comalatech.confluence.util.RenderUtils;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;

public abstract class AbstractMessageMacro
extends AbstractActionMacro {
    @ComponentImport
    private WikiStyleRenderer wikiStyleRenderer;
    @ComponentImport
    private SubRenderer subRenderer;

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String replaceReferences(RenderContext renderContext, String body) {
        body = RenderUtils.javaScriptBlock(body);
        ValueStore valueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
        return valueStore.replaceReferences(body);
    }

    public String renderMessageBody(RenderContext renderContext, RenderMode renderMode, String body) throws WorkflowException {
        return this.renderMessageBody(renderContext, renderMode, body, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderMessageBody(RenderContext renderContext, RenderMode renderMode, String body, boolean ignoreErrors) throws WorkflowException {
        renderContext.pushRenderMode(renderMode);
        try {
            body = this.replaceReferences(renderContext, body);
            String wikiMessage = this.wikiStyleRenderer.convertWikiToXHtml(renderContext, body);
            if (!ignoreErrors && AbstractMessageMacro.hasError(wikiMessage)) {
                throw new WorkflowException(wikiMessage);
            }
            String string = wikiMessage;
            return string;
        }
        finally {
            renderContext.popRenderMode();
        }
    }

    public String renderMessageBodyAsText(RenderContext renderContext, String body) throws WorkflowException {
        body = this.replaceReferences(renderContext, body);
        return this.subRenderer.renderAsText(body, renderContext);
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    @Override
    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }
}

