/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflow.ApproverConditionParser;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.macros.templates.BaseMacro;
import com.comalatech.confluence.workflow.model.ApproverCondition;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.HasApprovalCondition;
import com.comalatech.confluence.workflow.model.HasLabelCondition;
import com.comalatech.confluence.workflow.model.HasPendingTasksCondition;
import com.comalatech.confluence.workflow.model.HasViewWorkflowPermission;
import com.comalatech.confluence.workflow.model.IsAssignmentCondition;
import com.comalatech.confluence.workflow.model.IsChildOfCondition;
import com.comalatech.confluence.workflow.model.IsHomePageCondition;
import com.comalatech.confluence.workflow.model.IsMinorChangeCondition;
import com.comalatech.confluence.workflow.model.IsOrphanCondition;
import com.comalatech.confluence.workflow.model.IsValueAsUserSetCondition;
import com.comalatech.confluence.workflow.model.MetadataCondition;
import com.comalatech.confluence.workflow.model.PageTitleCondition;
import com.comalatech.confluence.workflow.model.ParentHasLabelCondition;
import com.comalatech.confluence.workflow.model.PermissionCondition;
import com.comalatech.confluence.workflow.model.SpaceKeyCondition;
import com.comalatech.confluence.workflow.model.StateCondition;
import com.comalatech.confluence.workflow.model.StateInDraftSpaceCondition;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractConditionalMacro
extends BaseMacro {
    private static final String PARAM_LABEL = "haslabel";
    private static final String PARAM_USERGROUP = "usergroup";
    private static final String PARAM_HAS_APPROVAL = "hasapproval";
    private static final String PARAM_PERMISSION = "permission";
    private static final String PARAM_TITLE = "title";
    private static final String PARAM_IS_HOME = "ishomepage";
    private static final String PARAM_IS_ORPHAN = "isorphan";
    private static final String PARAM_IS_CHILDOF = "ischildof";
    private static final String PARAM_IS_ASSIGNMENT = "isassignment";
    private static final String PARAM_SPACE = "space";
    private static final String PARAM_SPACE_KEY = "spacekey";
    private static final String PARAM_SELECTAPPROVER = "selectedapprover";
    private static final String PARAM_SELECTAPPROVERS = "selectedapprovers";
    private static final String PARAM_ISMINOREDIT = "isminorchange";
    private static final String PARAM_PARENTHASLABEL = "parenthaslabel";
    private static final String PARAM_PENDINGTASKS = "pendingtasks";
    private static final String PARAM_USERSDEFINED = "usersdefined";
    private static final String PARAM_ALLOWEDASSIGNUSERS = "allowedassignusers";
    private static final String PARAM_ALLOWEDASSIGNGROUPS = "allowedassigngroups";
    public static final String PARAM_HASVIEWWORKFLOW = "viewworkflow";
    public static final String PARAM_EXCLUDE_USER = "exclude";
    public static final String PARAM_MINIMUM = "minimum";
    protected static final String PARAM_USER = "user";
    protected static final String PARAM_GROUP = "group";
    protected static final String PARAM_STATE_IN_DRAFT_SPACE = "stateindraft";
    protected static final String PARAM_STATE = "state";
    protected static final String PARAM_CAPTION = "caption";
    protected static final String PARAM_HINT = "hint";
    private static final String[] USERCONDITION_PARAMS = new String[]{"user", "usergroup", "group", "selectedapprover", "selectedapprovers", "exclude", "allowedassignusers", "allowedassigngroups"};
    private InternalWorkflowParameterManager workflowParameterManager;
    protected ComalaI18nBean comalaI18nBean;

    @Override
    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public abstract boolean allowsAnonymousUser();

    protected void parseParameters(Map parameters, List conditions, List flags, Map macroParameters, AbstractPage page) throws MacroException {
        String[] rawParams = ((String)parameters.get(": = | RAW | = :")).split("\\|");
        Set macroParameterNames = macroParameters.keySet();
        for (String parameterName : macroParameterNames) {
            String value = (String)parameters.get(parameterName);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            macroParameters.put(parameterName, value);
        }
        for (int i = 0; i < rawParams.length; ++i) {
            Condition condition;
            String rawParam = rawParams[i];
            int ix = rawParam.indexOf(61);
            if (ix < 0) {
                flags.add(rawParam);
                continue;
            }
            String refName = rawParam.substring(0, ix).trim();
            String compValue = rawParam.substring(ix + 1).trim();
            if (macroParameterNames.contains(refName)) continue;
            boolean not = false;
            if (compValue.startsWith("!")) {
                not = true;
                compValue = compValue.substring(1).trim();
            }
            if (refName.equalsIgnoreCase(PARAM_LABEL)) {
                condition = new HasLabelCondition(not, AbstractConditionalMacro.parseLabels(compValue));
            } else if (refName.equalsIgnoreCase(PARAM_PARENTHASLABEL)) {
                condition = new ParentHasLabelCondition(not, AbstractConditionalMacro.parseLabels(compValue));
            } else if (this.equals(refName, USERCONDITION_PARAMS)) {
                String expression;
                if (compValue.toLowerCase().contains("anonymous".toLowerCase()) && !this.allowsAnonymousUser()) {
                    throw new MacroException(this.comalaI18nBean.getText("approvalsworkflow.approvals.anonymous-not-allowed"));
                }
                if (refName.equalsIgnoreCase(PARAM_SELECTAPPROVER)) {
                    expression = "?" + compValue;
                    refName = PARAM_USER;
                } else if (refName.equalsIgnoreCase(PARAM_SELECTAPPROVERS)) {
                    expression = "+" + compValue;
                    refName = PARAM_USER;
                } else {
                    expression = (not ? "!" : "") + compValue;
                }
                try {
                    condition = ApproverConditionParser.parse(refName, expression);
                }
                catch (WorkflowException e) {
                    throw new MacroException("error in '" + expression + "' :" + e.getMessage());
                }
                if (condition instanceof ApproverCondition) {
                    ApproverCondition approverCondition = (ApproverCondition)condition;
                    approverCondition.getSelector().setCaption((String)macroParameters.get(PARAM_CAPTION));
                    approverCondition.getSelector().setHint((String)macroParameters.get(PARAM_HINT));
                    approverCondition.getSelector().setMinimum((String)macroParameters.get(PARAM_MINIMUM));
                }
            } else if (refName.equalsIgnoreCase(PARAM_HAS_APPROVAL)) {
                condition = new HasApprovalCondition(not, compValue, true);
            } else if (refName.equalsIgnoreCase(PARAM_TITLE)) {
                condition = new PageTitleCondition(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_IS_HOME)) {
                if (page instanceof BlogPost) {
                    throw new MacroException("ishomepage can only be used only in a Page");
                }
                condition = new IsHomePageCondition(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_IS_ORPHAN)) {
                if (page instanceof BlogPost) {
                    throw new MacroException("isorphan can only be used only in a Page");
                }
                condition = new IsOrphanCondition(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_IS_CHILDOF)) {
                condition = new IsChildOfCondition(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_IS_ASSIGNMENT)) {
                condition = new IsAssignmentCondition(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_ISMINOREDIT)) {
                condition = new IsMinorChangeCondition(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_PENDINGTASKS)) {
                condition = new HasPendingTasksCondition(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_STATE_IN_DRAFT_SPACE)) {
                condition = new StateInDraftSpaceCondition(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_USERSDEFINED)) {
                condition = new IsValueAsUserSetCondition(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_PERMISSION)) {
                try {
                    condition = new PermissionCondition(not, compValue);
                }
                catch (WorkflowException e) {
                    throw new MacroException(e.getMessage());
                }
            } else if (refName.equalsIgnoreCase(PARAM_HASVIEWWORKFLOW)) {
                condition = new HasViewWorkflowPermission(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_SPACE) || refName.equalsIgnoreCase(PARAM_SPACE_KEY)) {
                condition = new SpaceKeyCondition(not, compValue);
            } else if (refName.equalsIgnoreCase(PARAM_STATE)) {
                condition = new StateCondition(not, compValue);
            } else if (refName.startsWith("@")) {
                condition = new MetadataCondition(not, refName, compValue);
            } else {
                throw new MacroException("invalid parameter " + rawParam);
            }
            conditions.add(condition);
        }
    }

    public boolean equals(String str, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (!value.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static Label[] parseLabels(String labelNamesList) throws MacroException {
        String[] labelNames = Condition.makeValues(labelNamesList);
        Label[] labels = new Label[labelNames.length];
        for (int i = 0; i < labelNames.length; ++i) {
            labels[i] = AbstractConditionalMacro.parseLabel(labelNames[i]);
        }
        return labels;
    }

    public static Label parseLabel(String labelName) throws MacroException {
        if (!StringUtils.isNotBlank((CharSequence)labelName) || LabelParser.parse((String)labelName) == null) {
            throw new MacroException("Invalid label name '" + labelName + "'. Labels should not contain " + LabelParser.getInvalidCharactersAsString());
        }
        return new Label(labelName);
    }

    public static Label parseLabelNullAllowed(String labelName) throws MacroException {
        if (StringUtils.isNotBlank((CharSequence)labelName) && LabelParser.parse((String)labelName) == null) {
            throw new MacroException("Invalid label name '" + labelName + "'. Labels should not contain " + LabelParser.getInvalidCharactersAsString());
        }
        return new Label(labelName);
    }

    public void setWorkflowParameterManager(InternalWorkflowParameterManager workflowParameterManager) {
        this.workflowParameterManager = workflowParameterManager;
    }

    public void setComalaI18nBean(ComalaI18nBean comalaI18nBean) {
        this.comalaI18nBean = comalaI18nBean;
    }
}

