/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners.triggers.tasks;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.manager.EventHistoryManager;
import com.comalatech.confluence.tasks.event.AllTasksCompleteEvent;
import com.comalatech.confluence.tasks.event.blogpost.AllBlogPostTasksCompleteEvent;
import com.comalatech.confluence.tasks.event.page.AllPageTasksCompleteEvent;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.listeners.StateHandler;
import com.comalatech.confluence.workflow.listeners.triggers.TriggersListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllTasksTriggersListener
extends TriggersListener {
    private static final Logger log = LoggerFactory.getLogger(AllTasksTriggersListener.class);
    private final StateHandler stateHandler;

    public AllTasksTriggersListener(WorkflowAccessor workflowAccessor, WorkflowActionManager workflowActionManager, @ComponentImport EventPublisher eventPublisher, StateHandler stateHandler, EventHistoryManager eventHistoryManager, @ComponentImport DarkFeatureManager darkFeatureManager) {
        super(workflowAccessor, workflowActionManager, eventHistoryManager, darkFeatureManager, eventPublisher);
        this.stateHandler = stateHandler;
    }

    @EventListener
    public void onAllBlogPostTasksCompleteEvent(AllBlogPostTasksCompleteEvent event) {
        this.handleEventTrigger((ContentEvent)event);
    }

    @EventListener
    public void onAllPageTasksCompleteEvent(AllPageTasksCompleteEvent event) {
        this.handleEventTrigger((ContentEvent)event);
    }

    @Override
    public void handleEventTrigger(ContentEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            this.processHistoryEvent(event);
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            this.stateHandler.handle((AllTasksCompleteEvent)event, pageWorkflows);
            this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }
}

