/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners;

import com.atlassian.confluence.event.events.content.attachment.AttachmentTrashedEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentChangedEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentRemoveEvent;
import org.springframework.stereotype.Component;

@Component
public class AttachmentTrashedListener
extends WorkflowsListener {
    public AttachmentTrashedListener(@ComponentImport EventPublisher eventPublisher) {
        super(eventPublisher);
    }

    @EventListener
    public void handle(AttachmentTrashedEvent event) {
        if (event.getContent() instanceof AbstractPage) {
            AbstractPage page = (AbstractPage)event.getContent();
            for (Attachment attachment : event.getAttachments()) {
                WorkflowAttachmentRemoveEvent workflowEvent = new WorkflowAttachmentRemoveEvent(event.getSource(), attachment, page);
                this.eventPublisher.publish((Object)workflowEvent);
                WorkflowAttachmentChangedEvent attachmentChangedEvent = new WorkflowAttachmentChangedEvent(event.getSource(), attachment, page);
                this.eventPublisher.publish((Object)attachmentChangedEvent);
            }
        }
    }
}

