/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit.service;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflow.audit.dao.WorkflowAuditLogDao;
import com.comalatech.confluence.workflow.audit.mapper.WorkflowAuditMapper;
import com.comalatech.confluence.workflow.audit.model.AuditLegacyRecord;
import com.comalatech.confluence.workflow.audit.model.AuditRecord;
import com.comalatech.confluence.workflow.audit.service.AuditService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class WorkflowAuditService
implements AuditService {
    private final com.atlassian.audit.api.AuditService confluenceAuditService;
    private final WorkflowAuditMapper workflowAuditMapper;
    private final WorkflowAuditLogDao workflowAuditLogDao;

    public WorkflowAuditService(@ComponentImport com.atlassian.audit.api.AuditService confluenceAuditService, @ComponentImport SettingsManager globalSettingsManager, WorkflowAuditLogDao workflowAuditLogDao, ComalaI18nBean comalaI18nBean) {
        this.confluenceAuditService = confluenceAuditService;
        this.workflowAuditLogDao = workflowAuditLogDao;
        this.workflowAuditMapper = new WorkflowAuditMapper(globalSettingsManager, comalaI18nBean);
    }

    @Override
    public void addRecord(AuditRecord auditRecord) {
        if (auditRecord.getNewValues() == null || !auditRecord.getNewValues().containsKey("value") || auditRecord.getNewValues().containsKey("value") && StringUtils.isNotBlank((CharSequence)auditRecord.getNewValues().get("value"))) {
            this.confluenceAuditService.audit(this.workflowAuditMapper.toAuditEvent(auditRecord));
        }
    }

    @Override
    public List<AuditLegacyRecord> getLegacyRecords(@Nullable String spaceKey) {
        return this.workflowAuditLogDao.getAuditLogRecords(spaceKey);
    }
}

