/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit.action;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.audit.model.AuditLegacyRecord;
import com.comalatech.confluence.workflow.audit.service.AuditService;
import java.util.List;

@WebSudoRequired
public class GlobalWorkflowsViewAuditLogAction
extends ConfluenceActionSupport {
    public static final int ITEMS_PER_PAGE = 100;
    private AuditService workflowAuditService;
    @ComponentImport
    private UserAccessor userAccessor;
    private WorkflowConfigurationManager workflowConfigurationManager;
    protected PaginationSupport paginationSupport;
    private String docoUrl = "https://apps.appf.re/cdmdc/doc/auditlog/9Gq5oQ";

    public GlobalWorkflowsViewAuditLogAction() {
        this(100);
    }

    public GlobalWorkflowsViewAuditLogAction(int itemsPerPage) {
        this.paginationSupport = new PaginationSupport(itemsPerPage);
    }

    public String execute() throws Exception {
        List<AuditLegacyRecord> items = this.getItems();
        if (items != null) {
            this.getPaginationSupport().setItems(items);
        }
        return "success";
    }

    public List<AuditLegacyRecord> getItems() {
        return this.workflowAuditService.getLegacyRecords(null);
    }

    public PaginationSupport getPaginationSupport() {
        return this.paginationSupport;
    }

    public void setStartIndex(int startIndex) {
        this.paginationSupport.setStartIndex(startIndex);
    }

    public ConfluenceUser getUserByKey(String key) {
        return this.userAccessor.getUserByKey(new UserKey(key));
    }

    public String getAuditLoggingStatusHtml() {
        Boolean auditLoggingEnabled = this.workflowConfigurationManager.isAuditLoggingEnabled();
        boolean enabled = auditLoggingEnabled == null ? false : auditLoggingEnabled;
        String css = enabled ? "aui-lozenge-success" : "";
        return String.format("<span class=\"aui-lozenge %s\">%s</span>", css, this.getText("approvalsworkflow.configuration.section.auditlog.enabled." + enabled));
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setWorkflowAuditService(AuditService workflowAuditService) {
        this.workflowAuditService = workflowAuditService;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public String getDocoUrl() {
        return this.docoUrl;
    }
}

