/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.infrastructure.persistence.activeobjects;

import com.comalatech.confluence.util.ActiveObjectsAccessor;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.contracts.WorkflowsMarkupAnalyticsAccessor;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.infrastructure.persistence.activeobjects.entity.BaseWorkflowsAnalitycsMarkupStorageRecord;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.infrastructure.persistence.activeobjects.entity.WorkflowsAnalyticsRecordEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowsMarkupAnalyticsAccessorImpl
extends ActiveObjectsAccessor
implements WorkflowsMarkupAnalyticsAccessor<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsMarkupAnalyticsAccessorImpl.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void persist(Map<String, Object> markupAnalyticsStats) {
        this.getAo().executeInTransaction(() -> {
            try {
                return this.createRecord(markupAnalyticsStats);
            }
            catch (IOException e) {
                log.error("error at saving markup analytics", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public List<Map<String, Object>> getAll() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            WorkflowsAnalyticsRecordEntity[] workflowsAnalyticsRecordEntities;
            for (WorkflowsAnalyticsRecordEntity entity : workflowsAnalyticsRecordEntities = (WorkflowsAnalyticsRecordEntity[])this.getAo().find(WorkflowsAnalyticsRecordEntity.class)) {
                JsonNode jsonNode = this.objectMapper.readTree(entity.getMarkupAnalytics());
                Map storedMarkupAsMap = (Map)this.objectMapper.convertValue((Object)jsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
                result.add(storedMarkupAsMap);
            }
        }
        catch (Exception e) {
            log.error("Cannot retrieve data from markup analytics table !! ", (Throwable)e);
        }
        return result;
    }

    @Override
    public void removeOldestRecord() {
        this.getAo().executeInTransaction(() -> {
            RawEntity[] workflowsAnalyticsRecordEntities = (WorkflowsAnalyticsRecordEntity[])this.getAo().find(WorkflowsAnalyticsRecordEntity.class, Query.select().order("CREATED_TIMESTAMP ASC").limit(1));
            this.getAo().delete(workflowsAnalyticsRecordEntities);
            return null;
        });
    }

    @Override
    public int countNumberOfRecords() {
        return this.getAo().count(WorkflowsAnalyticsRecordEntity.class);
    }

    private BaseWorkflowsAnalitycsMarkupStorageRecord createRecord(Map<String, Object> workflow) throws IOException {
        String analyticsJsonString = this.objectMapper.writeValueAsString(workflow);
        WorkflowsAnalyticsRecordEntity entity = (WorkflowsAnalyticsRecordEntity)this.getAo().create(WorkflowsAnalyticsRecordEntity.class, new DBParam[]{new DBParam("MARKUP_ANALYTICS", (Object)analyticsJsonString), new DBParam("CREATED_TIMESTAMP", (Object)System.currentTimeMillis())});
        entity.save();
        if (log.isDebugEnabled()) {
            log.debug("Markup saved {} ", (Object)entity.toString());
        }
        return entity;
    }
}

