/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup;

import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.WorkflowMarkupAnalyticsGenerationUseCase;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.WorkflowsMergeUseCase;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.contracts.WorkflowsMarkupAnalyticsAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowsAnalyticsThreeMonthsGenerationUseCase {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsAnalyticsThreeMonthsGenerationUseCase.class);
    protected static final int THREE_MONTHS_ROWS = 90;
    protected static final String NUMBER_OF_ROWS_PROCESSED = "numberOfRowsProcessed";
    private final WorkflowsMarkupAnalyticsAccessor<Map<String, Object>> markupAnalyticsLocalStorage;
    private final WorkflowMarkupAnalyticsGenerationUseCase workflowMarkupAnalyticsGenerationUseCase;
    private final WorkflowsMergeUseCase workflowsMergeUseCase;

    public WorkflowsAnalyticsThreeMonthsGenerationUseCase(WorkflowsMarkupAnalyticsAccessor<Map<String, Object>> markupAnalyticsLocalStorage, WorkflowMarkupAnalyticsGenerationUseCase workflowMarkupAnalyticsGenerationUseCase) {
        this.markupAnalyticsLocalStorage = markupAnalyticsLocalStorage;
        this.workflowMarkupAnalyticsGenerationUseCase = workflowMarkupAnalyticsGenerationUseCase;
        this.workflowsMergeUseCase = new WorkflowsMergeUseCase(new ObjectMapper());
    }

    public Map<String, Object> generateThreeMonthsAggregate() {
        HashMap result = new HashMap();
        try {
            Map<String, Object> todayMarkupAnalytics = this.workflowMarkupAnalyticsGenerationUseCase.perform();
            int numberOfRecords = this.markupAnalyticsLocalStorage.countNumberOfRecords();
            if (numberOfRecords >= 90) {
                this.markupAnalyticsLocalStorage.removeOldestRecord();
            }
            this.markupAnalyticsLocalStorage.persist(todayMarkupAnalytics);
            List<Map<String, Object>> searchByDate = this.markupAnalyticsLocalStorage.getAll();
            result = searchByDate.stream().reduce(new HashMap(), (accumulator, currentWorkflow) -> (HashMap)this.workflowsMergeUseCase.merge((Map<String, Object>)accumulator, (Map<String, Object>)currentWorkflow), (partialAccumulator, otherPartialAccumulator) -> (HashMap)this.workflowsMergeUseCase.merge((Map<String, Object>)partialAccumulator, (Map<String, Object>)partialAccumulator));
            result.put(NUMBER_OF_ROWS_PROCESSED, new HashSet<String>(Collections.singletonList(String.valueOf(numberOfRecords))));
        }
        catch (Exception e) {
            log.warn("Error performing markup analytics 90 generation {}", (Object)e.getMessage());
        }
        return result;
    }
}

