/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup;

import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.MapWorkflowsMarkupParserUseCase;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.WorkflowsMergeUseCase;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.contracts.WorkflowsStoreGateway;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowMarkupAnalyticsGenerationUseCase {
    private static final Logger log = LoggerFactory.getLogger(WorkflowMarkupAnalyticsGenerationUseCase.class);
    private final WorkflowsStoreGateway<String, String> analyticsStoreGateway;
    private final ObjectMapper objectMapper;
    final WorkflowsMergeUseCase workflowsMergeUseCase;
    final MapWorkflowsMarkupParserUseCase parser;

    public WorkflowMarkupAnalyticsGenerationUseCase(WorkflowsStoreGateway<String, String> analyticsStoreGateway) {
        this.analyticsStoreGateway = analyticsStoreGateway;
        this.objectMapper = new ObjectMapper();
        this.workflowsMergeUseCase = new WorkflowsMergeUseCase(this.objectMapper);
        this.parser = new MapWorkflowsMarkupParserUseCase();
    }

    public Map<String, Object> perform() {
        HashMap result = new HashMap();
        try {
            log.debug("===[START Generating Workflow Markup Analitycs]===");
            result = this.analyticsStoreGateway.getAll().map(this.workflowsMergeUseCase::toJsonNode).map(Optional::get).map(jsonNode -> this.objectMapper.convertValue(jsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){})).reduce(new HashMap(), (accumulator, currentWorkflow) -> this.getStringObjectHashMap((HashMap<String, Object>)accumulator, (HashMap)currentWorkflow), (partialAccumulator, otherPartialAccumulator) -> (HashMap)this.workflowsMergeUseCase.merge((Map<String, Object>)partialAccumulator, (Map<String, Object>)partialAccumulator));
            log.debug("===[END Generating Workflow Markup Analytics]===");
            this.analyticsStoreGateway.removeAll();
        }
        catch (Exception e) {
            log.warn("Error performing markup analytics generation {}", (Object)e.getMessage());
        }
        return result;
    }

    private HashMap<String, Object> getStringObjectHashMap(HashMap<String, Object> accumulator, HashMap<String, Object> currentWorkflow) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        currentWorkflow.entrySet().forEach(keyValue -> this.parser.parseProperties.andThen(this.parser.parseReadAck).andThen(this.parser.parseStates).andThen(this.parser.parseTriggers).andThen(this.parser.parseParameters).accept((Map.Entry<String, Object>)keyValue, (Map<String, Object>)map));
        return (HashMap)this.workflowsMergeUseCase.merge(accumulator, map);
    }
}

