/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.core.util.PairType;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.analytics.AnalyticsManager;
import com.comalatech.confluence.documentActions.model.DocumentActionsDashboard;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.tasks.model.StateTasksMode;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.events.admin.WorkflowConfigurationUpdatedEventImpl;
import com.comalatech.confluence.workflow.model.WorkflowConfiguration;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowcontainer.model.RequireApprovalComment;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.model.MacroTransformStatus;
import com.comalatech.workflow.model.PageUpdateResetApprovalStatus;
import com.comalatech.workflow.model.TasksMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationAction.class);
    private static final String SPACE_DISPLAY_PATH = "/display/";
    private WorkflowConfigurationManager workflowConfigurationManager;
    private WorkflowStatisticsManager workflowStatisticsManager;
    private AnalyticsManager analyticsManager;
    @ComponentImport
    private SpaceManager spaceManager;
    @ComponentImport
    private FormatSettingsManager formatSettingsManager;
    private WorkflowConfiguration workflowConfiguration;
    private WorkflowContainerManager workflowContainerManager;
    private AdhocWorkflowsLicenseManager licenseManager;
    @ComponentImport
    private EventPublisher eventPublisher;
    private WorkflowsFeatureManager workflowsFeatureManager;
    @ComponentImport
    private SettingsManager settingsManager;
    private LocaleManager localeManager;
    @ComponentImport
    private ApplicationProperties applicationProperties;
    private boolean editMode = true;
    private String pageApprovalsSpaceKeys;
    private String isPageApprovalsRestricted;
    private String spaceWorkflowSpaceKeys;
    private String isSpaceWorkflowRestricted;
    private String importersGroup;
    private String errorMessage;
    private int maxEvents;
    private int thresholdInSeconds;
    private String confirm;
    private boolean emailAnyone;
    private boolean strictMode;
    private boolean statsEnabled;
    private boolean migrationAssessmentEnabled;
    private boolean auditlogEnabled;
    private String resetApproval;
    private RequireApprovalComment requireApprovalComment;
    private String resetSpaceTasks;
    private String macroTransformEnable;
    private String documentActionsDashboardEnable;
    private boolean onboardEnabled;
    private boolean onboardTopBarEnabled;
    private boolean workflowTranslatorEnabled;
    private String historyVisibility;
    private final String docoUrlCDM = "https://apps.appf.re/cdmdc/doc/globalconfiguration/pVMxjI";
    private final String docoUrlCDC = "https://apps.appf.re/cdcdc/doc/globaladminandconfig/lU9NnR";
    private final String docoUrlCDA = "https://apps.appf.re/cdadc/doc/adminguide/8yZkg4";

    public String view() {
        this.editMode = false;
        this.workflowConfiguration = this.workflowConfigurationManager.getConfiguration();
        this.pageApprovalsSpaceKeys = this.workflowConfiguration.getPageApprovalsSpaceKeysAsString();
        this.spaceWorkflowSpaceKeys = this.workflowConfiguration.getSpaceWorkflowSpaceKeysAsString();
        this.isPageApprovalsRestricted = Boolean.toString(this.workflowConfiguration.getPageApprovalsRestricted());
        this.isSpaceWorkflowRestricted = Boolean.toString(this.workflowConfiguration.getSpaceWorkflowRestricted());
        this.maxEvents = this.workflowConfiguration.getMaxEvents();
        this.thresholdInSeconds = this.workflowConfiguration.getThresholdInSeconds();
        return "success";
    }

    public String edit() {
        this.view();
        this.editMode = true;
        return "success";
    }

    public String save() {
        this.editMode = true;
        if (this.confirm == null) {
            return "success";
        }
        Map<String, String> existingConfig = this.createConfigMap();
        WorkflowConfiguration newWorkflowConfiguration = new WorkflowConfiguration(this.workflowConfigurationManager.getConfiguration());
        try {
            if (this.workflowsFeatureManager.isWorkflowsApp()) {
                this.workflowConfigurationManager.setTasksMode((String)null, this.strictMode ? TasksMode.STRICT : TasksMode.LENIENT);
                this.resetSpaceTasks = this.resetSpaceTasks == null ? StateTasksMode.DEFAULT.toString() : this.resetSpaceTasks;
                this.workflowConfigurationManager.setStateTasksMode(null, StateTasksMode.parse(this.resetSpaceTasks));
                this.workflowConfigurationManager.setEmailAnyone(this.emailAnyone);
                this.workflowConfigurationManager.setRequireApprovalComment(this.requireApprovalComment);
                newWorkflowConfiguration.setMaxEvents(this.maxEvents);
                newWorkflowConfiguration.setThresholdInSeconds(this.thresholdInSeconds);
                this.workflowConfigurationManager.setImportersGroup(this.importersGroup);
                this.workflowConfigurationManager.setAuditLoggingEnabled(this.auditlogEnabled);
            }
            this.workflowConfigurationManager.setHistoryVisibility(WorkflowVisibilityInternal.parse(this.historyVisibility));
            this.workflowConfigurationManager.setMacroTransformEnable(MacroTransformStatus.valueOf(this.macroTransformEnable));
            this.workflowConfigurationManager.setResetApprovalStatus(PageUpdateResetApprovalStatus.valueOf(this.resetApproval));
            newWorkflowConfiguration.setPageApprovalsSpaceKeys(this.parseSpaceKeys("Page approvals", this.pageApprovalsSpaceKeys));
            newWorkflowConfiguration.setSpaceWorkflowSpaceKeys(this.parseSpaceKeys("Space workflows", this.spaceWorkflowSpaceKeys));
            newWorkflowConfiguration.setSpaceWorkflowRestricted(Boolean.parseBoolean(this.isSpaceWorkflowRestricted));
            newWorkflowConfiguration.setPageApprovalsRestricted(Boolean.parseBoolean(this.isPageApprovalsRestricted));
            newWorkflowConfiguration.init();
            this.workflowConfiguration = newWorkflowConfiguration;
            this.workflowConfigurationManager.setConfiguration(this.workflowConfiguration);
            this.workflowStatisticsManager.enableStats(this.statsEnabled);
            this.workflowStatisticsManager.enableMigrationAssessment(this.migrationAssessmentEnabled);
            this.analyticsManager.setEnabled(this.statsEnabled);
            this.workflowConfigurationManager.setOnboardEnabled(this.onboardEnabled);
            this.workflowConfigurationManager.setOnboardTopBarEnabled(this.onboardTopBarEnabled);
            this.workflowConfigurationManager.setWorkflowTranslatorEnabled(this.workflowTranslatorEnabled);
            this.workflowConfigurationManager.setDocumentActionsDashboardEnabled(DocumentActionsDashboard.valueOf(this.documentActionsDashboardEnable));
            this.errorMessage = null;
            Map<String, String> newConfig = this.createConfigMap();
            if (!existingConfig.equals(newConfig)) {
                WorkflowConfigurationUpdatedEventImpl updateEvent = new WorkflowConfigurationUpdatedEventImpl(existingConfig, newConfig);
                this.eventPublisher.publish((Object)updateEvent);
            }
        }
        catch (WorkflowException e) {
            this.editMode = true;
            this.errorMessage = e.getMessage();
            log.error(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.editMode = true;
            this.errorMessage = "Internal error, check server logs";
        }
        return this.view();
    }

    protected Map<String, String> createConfigMap() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("workflowVisibility", this.workflowConfigurationManager.getHistoryVisibility().toString());
        configMap.put("taskMode", this.workflowConfigurationManager.getTasksMode(null, false).toString());
        configMap.put("stateTaskBehaviour", this.workflowConfigurationManager.getStateTasksMode(null, false).toString());
        configMap.put("defaultApprovalWorkflow", this.workflowConfigurationManager.getDefaultApprovalWorkflow(null, false));
        configMap.put("requireApprovalComment", this.workflowConfigurationManager.getRequireApprovalComment(false).toString());
        configMap.put("resetApproval", this.workflowConfigurationManager.getResetApprovalStatus().toString());
        configMap.put("usageStats", Boolean.toString(this.workflowStatisticsManager.isStatsEnabled()));
        configMap.put("migrationAssessmentEnabled", Boolean.toString(this.workflowStatisticsManager.isMigrationAssessmentEnabled()));
        configMap.put("spaceWorkflowSpaces", this.workflowConfigurationManager.getConfiguration().getSpaceWorkflowSpaceKeysAsString());
        configMap.put("pageWorkflowSpaces", this.workflowConfigurationManager.getConfiguration().getPageApprovalsSpaceKeysAsString());
        configMap.put("spaceWorkflowCheck", this.workflowConfigurationManager.getConfiguration().getSpaceWorkflowRestricted() + "");
        configMap.put("pageWorkflowCheck", this.workflowConfigurationManager.getConfiguration().getPageApprovalsRestricted() + "");
        configMap.put("workflowImportGroup", this.workflowConfigurationManager.getImportersGroup());
        configMap.put("emailAny", Boolean.toString(this.workflowConfigurationManager.isEmailAnyone()));
        configMap.put("loopMaxEvents", Integer.toString(this.workflowConfigurationManager.getConfiguration().getMaxEvents()));
        configMap.put("loopMaxTime", Integer.toString(this.workflowConfigurationManager.getConfiguration().getThresholdInSeconds()));
        configMap.put("includeMacroTransform", this.workflowConfigurationManager.getMacroTransformEnable().toString());
        configMap.put("auditLogging", this.workflowConfigurationManager.isAuditLoggingEnabled() + "");
        configMap.put("onboardEnabled", this.workflowConfigurationManager.isOnboardEnabled() + "");
        configMap.put("onboardTopBarEnabled", this.workflowConfigurationManager.isOnboardTopBarEnabled() + "");
        configMap.put("workflowTranslatorEnabled", this.workflowConfigurationManager.isWorkflowTranslatorEnabled() + "");
        configMap.put("documentActionsDashboardEnabled", this.workflowConfigurationManager.getDocumentActionsDashboardEnable().toString());
        return configMap;
    }

    private String[] parseSpaceKeys(String element, String spaceKeysAsString) throws WorkflowException {
        if (spaceKeysAsString == null) {
            throw new WorkflowException(element + " not set");
        }
        if (spaceKeysAsString.trim().isEmpty()) {
            return new String[0];
        }
        ArrayList<String> spaceKeys = new ArrayList<String>();
        for (String spaceKey : spaceKeysAsString.split(",")) {
            if (spaceKey.trim().equalsIgnoreCase("any")) {
                return new String[]{"ANY"};
            }
            if (this.spaceManager.getSpace(spaceKey.trim()) == null) {
                throw new WorkflowException(element + ": space '" + spaceKey + "' does not exist");
            }
            Space space = this.spaceManager.getSpace(spaceKey.trim());
            spaceKeys.add(space.getKey());
        }
        return spaceKeys.toArray(new String[spaceKeys.size()]);
    }

    private String getPermissionsBlurb(boolean any, String[] spaceKeys, boolean isRestricted) {
        String restrictionText = any && isRestricted || spaceKeys.length == 0 && !isRestricted || spaceKeys.length > 0 && isRestricted ? this.getText("comalatech.awp.space.settings.workflow.permissions.restricted") : this.getText("comalatech.awp.space.settings.workflow.permissions.allowed");
        String spacesListText = any || spaceKeys.length == 0 ? this.getText("comalatech.awp.space.settings.workflow.permissions.anySpace") : this.makeSpacesList(spaceKeys);
        return this.getText("comalatech.awp.space.settings.workflow.permissions.description", new String[]{restrictionText, spacesListText});
    }

    @HtmlSafe
    public String getPageApprovalsSpacesBlurb() {
        return this.getPermissionsBlurb(this.workflowConfiguration.isAnySpacePageApprovals(), this.workflowConfiguration.getPageApprovalsSpaceKeys(), this.workflowConfiguration.getPageApprovalsRestricted());
    }

    @HtmlSafe
    public String getSpaceWorkflowSpaceKeysBlurb() {
        return this.getPermissionsBlurb(this.workflowConfiguration.isAnySpaceWorkflows(), this.workflowConfiguration.getSpaceWorkflowSpaceKeys(), this.workflowConfiguration.getSpaceWorkflowRestricted());
    }

    public String getImportersGroup() {
        return this.workflowConfigurationManager.getImportersGroup();
    }

    public String getEmailAnyone() {
        return this.workflowConfigurationManager.isEmailAnyone() + "";
    }

    public boolean isStatsEnabled() {
        return this.workflowStatisticsManager.isStatsEnabled();
    }

    public boolean isMigrationAssessmentEnabled() {
        return this.workflowStatisticsManager.isMigrationAssessmentEnabled();
    }

    public boolean isWorkflowTranslatorEnabled() {
        this.workflowTranslatorEnabled = this.workflowConfigurationManager.isWorkflowTranslatorEnabled();
        return this.workflowTranslatorEnabled;
    }

    public Boolean isAuditlogEnabled() {
        return this.workflowConfigurationManager.isAuditLoggingEnabled();
    }

    public List<PairType> getEmailAnyoneList() {
        ArrayList<PairType> modes = new ArrayList<PairType>();
        modes.add(new PairType((Serializable)((Object)"true"), (Serializable)((Object)this.getText("approvalsworkflow.configuration.enabled"))));
        modes.add(new PairType((Serializable)((Object)"false"), (Serializable)((Object)this.getText("approvalsworkflow.configuration.disabled"))));
        return modes;
    }

    public String getPageApprovalsRestricted() {
        return this.isPageApprovalsRestricted;
    }

    public String getSpaceWorkflowRestricted() {
        return this.isSpaceWorkflowRestricted;
    }

    public String getStrictMode() {
        TasksMode tasksMode = this.workflowConfigurationManager.getTasksMode(null, false);
        return Boolean.toString(tasksMode == TasksMode.STRICT);
    }

    public List<PairType> getStrictModesList() {
        ArrayList<PairType> modes = new ArrayList<PairType>();
        modes.add(new PairType((Serializable)((Object)"true"), (Serializable)((Object)this.getText("comalatech.awp.space.settings.tasksmode.STRICT"))));
        modes.add(new PairType((Serializable)((Object)"false"), (Serializable)((Object)this.getText("comalatech.awp.space.settings.tasksmode.LENIENT"))));
        return modes;
    }

    private boolean isResetSpaceTasks() {
        return this.workflowConfigurationManager.getStateTasksMode(null, false) == StateTasksMode.RESET;
    }

    public String getResetSpaceTasks() {
        return this.isResetSpaceTasks() ? StateTasksMode.RESET.toString() : StateTasksMode.MOVE.toString();
    }

    public String getResetSpaceTasksHtml() {
        return this.isResetSpaceTasks() ? this.getText("comalatech.awp.space.settings.spacetasksmode.RESET") : this.getText("comalatech.awp.space.settings.spacetasksmode.MOVE");
    }

    public List<PairType> getResetSpaceTasksList() {
        ArrayList<PairType> visibilityOptions = new ArrayList<PairType>();
        visibilityOptions.add(new PairType((Serializable)((Object)StateTasksMode.RESET), (Serializable)((Object)this.getText("comalatech.awp.space.settings.spacetasksmode.RESET"))));
        visibilityOptions.add(new PairType((Serializable)((Object)StateTasksMode.MOVE), (Serializable)((Object)this.getText("comalatech.awp.space.settings.spacetasksmode.MOVE"))));
        return visibilityOptions;
    }

    public List<PairType> getMacroTransformEnableList() {
        ArrayList<PairType> transformOptions = new ArrayList<PairType>();
        transformOptions.add(new PairType((Serializable)((Object)MacroTransformStatus.DISABLED.toString()), (Serializable)((Object)this.getText("comalatech.awp.space.settings.macrotransform.DISABLED"))));
        transformOptions.add(new PairType((Serializable)((Object)MacroTransformStatus.ENABLED.toString()), (Serializable)((Object)this.getText("comalatech.awp.space.settings.macrotransform.ENABLED"))));
        return transformOptions;
    }

    public List<PairType> getDocumentActionsDashboardEnableList() {
        ArrayList<PairType> documentActionsDashboardOptions = new ArrayList<PairType>();
        documentActionsDashboardOptions.add(new PairType((Serializable)((Object)DocumentActionsDashboard.DISABLED.toString()), (Serializable)((Object)this.getText("workflows.configuration.documentActionsDashboardEnabled.disabled"))));
        documentActionsDashboardOptions.add(new PairType((Serializable)((Object)DocumentActionsDashboard.ENABLED.toString()), (Serializable)((Object)this.getText("workflows.configuration.documentActionsDashboardEnabled.enabled"))));
        return documentActionsDashboardOptions;
    }

    public List<PairType> getSpaceWorkflowRestrictedList() {
        ArrayList<PairType> options = new ArrayList<PairType>();
        options.add(new PairType((Serializable)((Object)Boolean.toString(false)), (Serializable)((Object)this.getText("comalatech.awp.space.settings.workflow.radio.ALLOWED"))));
        options.add(new PairType((Serializable)((Object)Boolean.toString(true)), (Serializable)((Object)this.getText("comalatech.awp.space.settings.workflow.radio.RESTRICTED"))));
        return options;
    }

    public List<PairType> getPageApprovalsRestrictedList() {
        ArrayList<PairType> options = new ArrayList<PairType>();
        options.add(new PairType((Serializable)((Object)Boolean.toString(false)), (Serializable)((Object)this.getText("comalatech.awp.space.settings.workflow.radio.ALLOWED"))));
        options.add(new PairType((Serializable)((Object)Boolean.toString(true)), (Serializable)((Object)this.getText("comalatech.awp.space.settings.workflow.radio.RESTRICTED"))));
        return options;
    }

    public List<PairType> getResetApprovalOptionsList() {
        ArrayList<PairType> resetApprovalOptions = new ArrayList<PairType>();
        resetApprovalOptions.add(new PairType((Serializable)((Object)PageUpdateResetApprovalStatus.RESET), (Serializable)((Object)this.getText("comalatech.awp.space.settings.resetapproval.RESET"))));
        resetApprovalOptions.add(new PairType((Serializable)((Object)PageUpdateResetApprovalStatus.IGNORE), (Serializable)((Object)this.getText("comalatech.awp.space.settings.resetapproval.IGNORE"))));
        return resetApprovalOptions;
    }

    public List<PairType> getRequireApprovalCommentList() {
        return Arrays.asList(new PairType((Serializable)((Object)RequireApprovalComment.OPTIONAL.toString()), (Serializable)((Object)this.getText("approvalsworkflow.configuration.requireApprovalComment.option.optional"))), new PairType((Serializable)((Object)RequireApprovalComment.REQUIRE.toString()), (Serializable)((Object)this.getText("approvalsworkflow.configuration.requireApprovalComment.option.require"))));
    }

    public String getRequireApprovalComment() {
        this.requireApprovalComment = this.workflowConfigurationManager.getRequireApprovalComment(true);
        return this.requireApprovalComment.toString();
    }

    public String getResetApprovalHtml() {
        return this.isResetApproval() ? this.getText("comalatech.awp.space.settings.resetapproval.RESET") : this.getText("comalatech.awp.space.settings.resetapproval.IGNORE");
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public String getHistoryVisibility() {
        return this.workflowConfigurationManager.getHistoryVisibility().toString();
    }

    public List<PairType> getVisibilityList() {
        ArrayList<PairType> visibilityOptions = new ArrayList<PairType>();
        for (WorkflowVisibilityInternal visibility : WorkflowVisibilityInternal.values()) {
            if (visibility == WorkflowVisibilityInternal.DEFAULT) continue;
            visibilityOptions.add(new PairType((Serializable)((Object)visibility.toString()), (Serializable)((Object)this.getText(visibility.getI18nKey()))));
        }
        return visibilityOptions;
    }

    public List<PairType> getGlobalWorkflowTemplatesList() {
        List<Workflow> workflows = this.workflowContainerManager.getAvailableWorkflowTemplates(null);
        ArrayList<PairType> names = new ArrayList<PairType>(workflows.size());
        names.add(new PairType((Serializable)((Object)""), (Serializable)((Object)"")));
        for (Workflow workflow : workflows) {
            names.add(new PairType((Serializable)((Object)workflow.getName()), (Serializable)((Object)workflow.getName())));
        }
        return names;
    }

    public String getDefaultApprovalWorkflow() {
        return this.workflowConfigurationManager.getDefaultApprovalWorkflow(null, false);
    }

    public void setDefaultApprovalWorkflow(String name) {
        this.workflowConfigurationManager.setDefaultApprovalWorkflow(null, name);
    }

    public DateFormatter getDateFormatter() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.userAccessor.getConfluenceUserPreferences((User)user).getDateFormatter(this.formatSettingsManager, this.localeManager);
    }

    private String makeSpacesList(String[] spaceKeys) {
        String spaceLinkPrefix = this.getBootstrapStatusProvider().getWebAppContextPath() + SPACE_DISPLAY_PATH;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String spaceKey : spaceKeys) {
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space == null) continue;
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append("<a href='").append(spaceLinkPrefix).append(space.getKey()).append("'>");
            sb.append(HtmlUtil.htmlEncode((String)space.getName())).append("</a>");
        }
        return sb.toString();
    }

    public WorkflowConfiguration getConfiguration() {
        return this.workflowConfiguration;
    }

    public String getBaseUrl() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    public void setLicenseManager(AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public String getMacroTransformEnable() {
        return this.workflowConfigurationManager.getMacroTransformEnable().toString();
    }

    public String getResetApproval() {
        return this.isResetApproval() ? PageUpdateResetApprovalStatus.RESET.toString() : PageUpdateResetApprovalStatus.IGNORE.toString();
    }

    public boolean isOnboardEnabled() {
        this.onboardEnabled = this.workflowConfigurationManager.isOnboardEnabled();
        return this.onboardEnabled;
    }

    public boolean isOnboardTopBarEnabled() {
        return this.workflowConfigurationManager.isOnboardTopBarEnabled();
    }

    public boolean showDisableAnalyticsToggleButton() {
        return this.analyticsManager.showDisableAnalyticsToggleButton();
    }

    public String getDocoUrl(String app) {
        String url = "https://apps.appf.re/cdmdc/doc/globalconfiguration/pVMxjI";
        if (app.equalsIgnoreCase("cda")) {
            url = "https://apps.appf.re/cdadc/doc/adminguide/8yZkg4";
        } else if (app.equalsIgnoreCase("cdc")) {
            url = "https://apps.appf.re/cdcdc/doc/globaladminandconfig/lU9NnR";
        }
        return url;
    }

    public String getDocumentActionsDashboardEnable() {
        return this.workflowConfigurationManager.getDocumentActionsDashboardEnable().toString();
    }

    @ParameterSafe
    public void setDocumentActionsDashboardEnable(String documentActionsDashboardEnable) {
        this.documentActionsDashboardEnable = documentActionsDashboardEnable;
    }

    @ParameterSafe
    public void setStatsEnabled(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
    }

    private boolean isResetApproval() {
        return this.workflowConfigurationManager.getResetApprovalStatus() == PageUpdateResetApprovalStatus.RESET;
    }

    @ParameterSafe
    public void setResetApproval(String resetApproval) {
        this.resetApproval = resetApproval;
    }

    @ParameterSafe
    public void setSpaceWorkflowSpaceKeys(String spaceWorkflowSpaceKeys) {
        this.spaceWorkflowSpaceKeys = spaceWorkflowSpaceKeys;
    }

    @ParameterSafe
    public void setPageApprovalsSpaceKeys(String pageApprovalsSpaceKeys) {
        this.pageApprovalsSpaceKeys = pageApprovalsSpaceKeys;
    }

    @ParameterSafe
    public void setMacroTransformEnable(String macroTransformEnable) {
        this.macroTransformEnable = macroTransformEnable;
    }

    @ParameterSafe
    public void setOnboardEnabled(boolean onboardEnabled) {
        this.onboardEnabled = onboardEnabled;
    }

    @ParameterSafe
    public void setHistoryVisibility(String historyVisibility) {
        this.historyVisibility = historyVisibility;
    }

    @ParameterSafe
    public void setSpaceWorkflowRestricted(String spaceWorkflowRestricted) {
        this.isSpaceWorkflowRestricted = spaceWorkflowRestricted;
    }

    @ParameterSafe
    public void setWorkflowTranslatorEnabled(boolean enabled) {
        this.workflowTranslatorEnabled = enabled;
    }

    @ParameterSafe
    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    @ParameterSafe
    public void setPageApprovalsRestricted(String pageApprovalsRestricted) {
        this.isPageApprovalsRestricted = pageApprovalsRestricted;
    }

    @ParameterSafe
    public void setStrictMode(String strictMode) {
        this.strictMode = Boolean.parseBoolean(strictMode);
    }

    @ParameterSafe
    public void setResetSpaceTasks(String resetSpaceTasks) {
        this.resetSpaceTasks = resetSpaceTasks;
    }

    @ParameterSafe
    public void setRequireApprovalComment(String requireApprovalComment) {
        this.requireApprovalComment = RequireApprovalComment.valueOf(requireApprovalComment);
    }

    @ParameterSafe
    public void setMigrationAssessmentEnabled(boolean migrationAssessmentEnabled) {
        this.migrationAssessmentEnabled = migrationAssessmentEnabled;
    }

    @ParameterSafe
    public void setOnboardTopBarEnabled(boolean onboardTopBarEnabled) {
        this.onboardTopBarEnabled = onboardTopBarEnabled;
    }

    @ParameterSafe
    public void setImportersGroup(String importersGroup) {
        this.importersGroup = importersGroup;
    }

    @ParameterSafe
    public void setEmailAnyone(String emailAnyone) {
        this.emailAnyone = Boolean.parseBoolean(emailAnyone);
    }

    @ParameterSafe
    public void setMaxEvents(int maxEvents) {
        this.maxEvents = maxEvents;
    }

    @ParameterSafe
    public void setAuditlogEnabled(boolean auditlogEnabled) {
        this.auditlogEnabled = auditlogEnabled;
    }

    @ParameterSafe
    public void setThresholdInSeconds(int thresholdInSeconds) {
        this.thresholdInSeconds = thresholdInSeconds;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public WorkflowStatisticsManager getWorkflowStatisticsManager() {
        return this.workflowStatisticsManager;
    }

    public void setWorkflowStatisticsManager(WorkflowStatisticsManager workflowStatisticsManager) {
        this.workflowStatisticsManager = workflowStatisticsManager;
    }

    public void setAnalyticsManager(AnalyticsManager analyticsManager) {
        this.analyticsManager = analyticsManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }

    public void setWorkflowContainerManager(WorkflowContainerManager workflowContainerManager) {
        this.workflowContainerManager = workflowContainerManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setWorkflowsFeatureManager(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public String getPageApprovalsSpaceKeys() {
        return this.pageApprovalsSpaceKeys;
    }

    public String getSpaceWorkflowSpaceKeys() {
        return this.spaceWorkflowSpaceKeys;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getMaxEvents() {
        return this.maxEvents;
    }

    public int getThresholdInSeconds() {
        return this.thresholdInSeconds;
    }
}

