/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.workflow.ApprovalRolesManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.events.ApprovalRoleAssignmentEvent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Component;

@Component
public class DefaultApprovalRolesManager
implements ApprovalRolesManager {
    private final BandanaManager bandanaManager;
    private final EventPublisher eventPublisher;
    private final String SPACE_APPROVAL_ROLES_BANDANA_KEY = "com.comalatech.workflows.approval.roles";

    public DefaultApprovalRolesManager(@ComponentImport BandanaManager bandanaManager, @ComponentImport EventPublisher eventPublisher) {
        this.bandanaManager = bandanaManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public List<String> getApprovalRoles(String spaceKey) {
        try {
            return this.parseJsonApprovalRoles(this.retrieveApprovalRoles(spaceKey));
        }
        catch (WorkflowException e) {
            return new ArrayList<String>();
        }
    }

    private String retrieveApprovalRoles(String spaceKey) {
        String approvalRoles = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), "com.comalatech.workflows.approval.roles", false);
        if (StringUtils.isBlank((CharSequence)approvalRoles)) {
            approvalRoles = "[]";
        }
        return approvalRoles;
    }

    @Override
    public void replaceApprovalRoles(String spaceKey, String jsonApprovalRoles) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), "com.comalatech.workflows.approval.roles", (Object)jsonApprovalRoles);
    }

    @Override
    public void updateApprovalRoles(String spaceKey, List<String> approvalRoles) throws WorkflowException {
        if (approvalRoles.size() > 0) {
            String jsonApprovalRoles = this.retrieveApprovalRoles(spaceKey);
            List<String> spaceApprovalRoles = this.parseJsonApprovalRoles(jsonApprovalRoles);
            spaceApprovalRoles = this.mergeApprovalRolesSets(spaceApprovalRoles, approvalRoles);
            this.replaceApprovalRoles(spaceKey, this.approvalRolesAsJson(spaceApprovalRoles));
            this.eventPublisher.publish((Object)new ApprovalRoleAssignmentEvent());
        }
    }

    @Override
    public void removeApprovalRoles(String spaceKey) {
        this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), "com.comalatech.workflows.approval.roles");
    }

    protected List<String> parseJsonApprovalRoles(String jsonApprovalRoles) throws WorkflowException {
        try {
            Object[] spaceRoles = (String[])new ObjectMapper().readValue(jsonApprovalRoles, String[].class);
            return Lists.newArrayList((Object[])spaceRoles);
        }
        catch (Exception e) {
            throw new WorkflowException("There was an error while parsing approval roles JSON: " + jsonApprovalRoles, e);
        }
    }

    protected List<String> mergeApprovalRolesSets(List<String> spaceApprovalRoles, List<String> approvalRoles) {
        for (String approvalRole : approvalRoles) {
            spaceApprovalRoles.remove(approvalRole);
            spaceApprovalRoles.add(0, approvalRole);
        }
        return spaceApprovalRoles.size() > 50 ? spaceApprovalRoles.subList(0, 50) : spaceApprovalRoles;
    }

    protected String approvalRolesAsJson(List<String> spaceApprovalRoles) throws WorkflowException {
        try {
            return new ObjectMapper().writeValueAsString(spaceApprovalRoles);
        }
        catch (Exception e) {
            throw new WorkflowException("There was an error while serializing approval roles to JSON", e);
        }
    }
}

