/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util.cql;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class CQLExpansionParser {
    public static Expansion[] parse(String ... individualExpansions) {
        return new ExpansionsParserImpl().parseExpansion(individualExpansions).toArray();
    }

    public static Expansion[] parse(String expand) {
        return StringUtils.isBlank((CharSequence)expand) ? new Expansion[]{} : CQLExpansionParser.parse(expand.split(","));
    }

    private static final class ExpansionsParserImpl {
        private ExpansionsParserImpl() {
        }

        public Expansions parseExpansion(String ... individualExpansions) {
            ArrayList<Expansion> expandyBits = new ArrayList<Expansion>(individualExpansions.length);
            for (String individualExpansion : individualExpansions) {
                expandyBits.add(this.toExpansion(individualExpansion));
            }
            return new Expansions(expandyBits);
        }

        private Expansion toExpansion(String individualExpansion) {
            String[] pathParts = individualExpansion.split("\\.");
            return this.toExpansion(pathParts);
        }

        private Expansion toExpansion(String[] pathDotParts) {
            String pathStart = pathDotParts[0];
            return pathDotParts.length == 1 ? new Expansion(pathStart) : new Expansion(pathStart, new Expansions(new Expansion[]{this.toExpansion(this.rest(pathDotParts))}));
        }

        private String[] rest(String[] pathParts) {
            return Arrays.copyOfRange(pathParts, 1, pathParts.length);
        }
    }
}

