/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.dataextractor;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.readack.ReadAckException;
import com.comalatech.confluence.readack.dataextractor.ReadAckContentPropertyModel;
import com.comalatech.confluence.readack.model.ReadAckPageStatus;
import com.comalatech.confluence.readack.service.ReadAckManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReadAckPropertyExtractor {
    private static final Logger log = LoggerFactory.getLogger(ReadAckPropertyExtractor.class);
    private final ReadAckManager readAckManager;
    private final WorkflowPermissionManager workflowPermissionManager;

    public ReadAckPropertyExtractor(ReadAckManager readAckManager, WorkflowPermissionManager workflowPermissionManager) {
        this.readAckManager = readAckManager;
        this.workflowPermissionManager = workflowPermissionManager;
    }

    public String getJsonOf(AbstractPage page) {
        ReadAckContentPropertyModel data = this.extractFrom(page);
        return data != null ? ReadAckPropertyExtractor.serialize(data) : null;
    }

    private ReadAckContentPropertyModel extractFrom(AbstractPage page) {
        String readAckStatus = "";
        Integer pendingUsers = null;
        Integer ackUsers = null;
        Date dueDate = null;
        ReadAckPageStatus readAckPageStatus = null;
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            boolean canViewWorkflows = this.workflowPermissionManager.canViewWorkflows(page.getSpace(), user);
            readAckPageStatus = this.readAckManager.getPageStatus(page, canViewWorkflows, true);
            if (readAckPageStatus != null) {
                readAckStatus = readAckPageStatus.getPageStatus().toString();
                pendingUsers = readAckPageStatus.getPendingUsers();
                ackUsers = readAckPageStatus.getAckUsers();
                if (readAckPageStatus.getDueDate() != null) {
                    dueDate = new Date(readAckPageStatus.getDueDate());
                }
            }
        }
        catch (ReadAckException raEx) {
            log.error("Problems getting the read ack status related to " + page, (Throwable)raEx);
        }
        ReadAckContentPropertyModel contentPropertyModel = new ReadAckContentPropertyModel();
        contentPropertyModel.readAckStatus = readAckStatus;
        contentPropertyModel.ackUsers = ackUsers;
        contentPropertyModel.pendingUsers = pendingUsers;
        contentPropertyModel.readAckDueDate = dueDate;
        return contentPropertyModel;
    }

    public static String serialize(ReadAckContentPropertyModel data) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.disable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS});
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mapper.setDateFormat((DateFormat)df);
        try {
            return mapper.writeValueAsString((Object)data);
        }
        catch (Exception e) {
            log.error("ReadAckContentPropertyModel could not be serializated", (Throwable)e);
            return null;
        }
    }

    public static ReadAckContentPropertyModel deserialize(String jsonCP) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.disable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS});
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mapper.setDateFormat((DateFormat)df);
        try {
            ReadAckContentPropertyModel cpmObj = (ReadAckContentPropertyModel)mapper.readValue(jsonCP, ReadAckContentPropertyModel.class);
            return cpmObj;
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }
}

