/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.activeObjects.accessor;

import com.comalatech.confluence.readack.activeObjects.accessor.ReadAckRecordAccessor;
import com.comalatech.confluence.readack.activeObjects.entity.BaseReadAckRecord;
import com.comalatech.confluence.readack.activeObjects.entity.ReadAckRecordEntity;
import com.comalatech.confluence.readack.model.ReadAckSearchCriteria;
import com.comalatech.confluence.readack.model.ReadAckSearchFilter;
import com.comalatech.confluence.readack.model.ReadAckStatusType;
import com.comalatech.confluence.util.ActiveObjectsAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReadAckRecordAccessorImpl
extends ActiveObjectsAccessor
implements ReadAckRecordAccessor {
    private static final Logger log = LoggerFactory.getLogger(ReadAckRecordAccessorImpl.class);

    @Override
    public BaseReadAckRecord save(BaseReadAckRecord record) {
        return (BaseReadAckRecord)this.getAo().executeInTransaction(() -> this.createOrUpdate(record));
    }

    @Override
    public List<BaseReadAckRecord> save(List<BaseReadAckRecord> records) {
        return (List)this.getAo().executeInTransaction(() -> {
            ArrayList<BaseReadAckRecord> results = new ArrayList<BaseReadAckRecord>();
            for (BaseReadAckRecord record : records) {
                results.add(this.createOrUpdate(record));
            }
            return results;
        });
    }

    private BaseReadAckRecord createOrUpdate(BaseReadAckRecord record) {
        if (record.getId() == null) {
            return this.createRecord(record);
        }
        return this.updateRecord(record);
    }

    private BaseReadAckRecord createRecord(BaseReadAckRecord record) {
        ReadAckRecordEntity entity = (ReadAckRecordEntity)this.getAo().create(ReadAckRecordEntity.class, new DBParam[]{new DBParam("USER_KEY", (Object)record.getUserKey()), new DBParam("PAGE_ID", (Object)record.getPageId()), new DBParam("PAGE_VERSION", (Object)record.getPageVersion()), new DBParam("PAGE_STATE_ID", (Object)record.getPageStateId()), new DBParam("STATUS", (Object)record.getStatus()), new DBParam("DUE_DATE_TIMESTAMP", (Object)record.getDueDateTimestamp()), new DBParam("CREATION_TIMESTAMP", (Object)record.getCreationTimestamp()), new DBParam("ACKNOWLEDGED_TIMESTAMP", null), new DBParam("CLOSED_TIMESTAMP", null), new DBParam("ASSIGNMENT_TYPE", (Object)record.getAssignmentType())});
        entity.save();
        if (log.isDebugEnabled()) {
            log.debug("ReadAck record has been created: \n" + record);
        }
        return entity;
    }

    private BaseReadAckRecord updateRecord(BaseReadAckRecord record) {
        ReadAckRecordEntity readAckRecordEntity = (ReadAckRecordEntity)this.getAo().get(ReadAckRecordEntity.class, (Object)record.getId());
        if (!record.getStatus().equals(readAckRecordEntity.getStatus())) {
            readAckRecordEntity.setStatus(record.getStatus());
        }
        if (record.getDueDateTimestamp() != null && !record.getDueDateTimestamp().equals(readAckRecordEntity.getDueDateTimestamp()) || record.getDueDateTimestamp() == null) {
            readAckRecordEntity.setDueDateTimestamp(record.getDueDateTimestamp());
        }
        if (record.getAcknowledgedTimestamp() != null && !record.getAcknowledgedTimestamp().equals(readAckRecordEntity.getAcknowledgedTimestamp())) {
            readAckRecordEntity.setAcknowledgedTimestamp(record.getAcknowledgedTimestamp());
        }
        if (record.getClosedTimestamp() != null && !record.getClosedTimestamp().equals(readAckRecordEntity.getClosedTimestamp())) {
            readAckRecordEntity.setClosedTimestamp(record.getClosedTimestamp());
        }
        if (record.getPageVersion() != null && readAckRecordEntity.getPageVersion() == null) {
            readAckRecordEntity.setPageVersion(record.getPageVersion());
        }
        readAckRecordEntity.save();
        if (log.isDebugEnabled()) {
            log.debug("ReadAck record has been updated: \n" + record);
        }
        return readAckRecordEntity;
    }

    @Override
    public List<BaseReadAckRecord> close(int pageStateId, List<Long> pageIds) {
        DateTime now = DateTime.now();
        List<ReadAckStatusType.UserStatusType> filterStatus = Collections.singletonList(ReadAckStatusType.UserStatusType.PENDING);
        String whereClause = "PAGE_ID IN (" + pageIds.stream().map(pageId -> "?").collect(Collectors.joining(",")) + ") AND " + "PAGE_STATE_ID" + " = ? AND " + "STATUS" + " IN (" + filterStatus.stream().map(status -> "?").collect(Collectors.joining(",")) + ")";
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.addAll(pageIds);
        parameters.add(pageStateId);
        parameters.addAll(filterStatus);
        return (List)this.getAo().executeInTransaction(() -> {
            ReadAckRecordEntity[] records;
            ArrayList<ReadAckRecordEntity> results = new ArrayList<ReadAckRecordEntity>();
            for (ReadAckRecordEntity record : records = (ReadAckRecordEntity[])this.getAo().find(ReadAckRecordEntity.class, Query.select().where(whereClause, parameters.toArray()))) {
                record.setStatus(ReadAckStatusType.UserStatusType.CLOSED);
                record.setClosedTimestamp(now.getMillis());
                record.save();
                results.add(record);
                if (!log.isDebugEnabled()) continue;
                log.debug("ReadAck record has been closed: \n" + record);
            }
            return results;
        });
    }

    @Override
    public void closeExtraRecords(List<BaseReadAckRecord> records) {
        DateTime now = DateTime.now();
        this.getAo().executeInTransaction(() -> {
            records.stream().forEach(r -> {
                ReadAckRecordEntity record = (ReadAckRecordEntity)this.getAo().get(ReadAckRecordEntity.class, (Object)r.getId());
                if (record != null) {
                    record.setStatus(ReadAckStatusType.UserStatusType.CLOSED);
                    record.setClosedTimestamp(now.getMillis());
                    record.save();
                }
            });
            return null;
        });
    }

    @Override
    public void delete(Long id) {
        this.getAo().executeInTransaction(() -> {
            this.deleteById(id);
            return null;
        });
    }

    private void deleteById(Long id) {
        ReadAckRecordEntity record = (ReadAckRecordEntity)this.getAo().get(ReadAckRecordEntity.class, (Object)id);
        if (record != null) {
            this.getAo().delete(new RawEntity[]{record});
        }
        if (log.isDebugEnabled()) {
            log.debug("ReadAck record has been deleted: \n" + record.toString());
        }
    }

    @Override
    public void delete(ReadAckSearchCriteria criteria) {
        this.getAo().executeInTransaction(() -> {
            Query query = this.buildQuery(criteria);
            if (query != null) {
                RawEntity[] records = (ReadAckRecordEntity[])this.getAo().find(ReadAckRecordEntity.class, query);
                this.getAo().delete(records);
            }
            return null;
        });
    }

    @Override
    public List<BaseReadAckRecord> search(ReadAckSearchCriteria criteria) {
        return this.search(criteria, null);
    }

    @Override
    public List<BaseReadAckRecord> search(ReadAckSearchCriteria criteria, ReadAckSearchFilter filter) {
        return (List)this.getAo().executeInTransaction(() -> {
            Query query = this.buildQuery(criteria);
            if (filter != null) {
                query = this.applyFilters(filter, query);
            }
            return query != null ? Arrays.asList((BaseReadAckRecord[])this.getAo().find(ReadAckRecordEntity.class, query)) : new ArrayList();
        });
    }

    @Override
    public Long count(ReadAckSearchCriteria criteria) {
        return (Long)this.getAo().executeInTransaction(() -> {
            Query query = this.buildQuery(criteria);
            return query != null ? (long)this.getAo().count(ReadAckRecordEntity.class, query) : 0L;
        });
    }

    @Override
    public List<Long> getOverduePages() {
        DateTime now = DateTime.now();
        String queryClause = "STATUS = ? AND DUE_DATE_TIMESTAMP < ?";
        Query query = Query.select((String)"PAGE_ID").distinct().where("STATUS = ? AND DUE_DATE_TIMESTAMP < ?", new Object[]{ReadAckStatusType.UserStatusType.PENDING, now.getMillis()}).order("DUE_DATE_TIMESTAMP ASC");
        ReadAckRecordEntity[] entities = (ReadAckRecordEntity[])this.getAo().find(ReadAckRecordEntity.class, query);
        return Arrays.asList(entities).stream().map(e -> e.getPageId()).distinct().collect(Collectors.toList());
    }

    @Override
    public List<BaseReadAckRecord> updateReadAckUsers(List<BaseReadAckRecord> usersToDelete, List<BaseReadAckRecord> usersToAdd) {
        return (List)this.getAo().executeInTransaction(() -> Stream.concat(usersToDelete.stream(), usersToAdd.stream()).map(this::createOrUpdate).filter(ackRecord -> ackRecord.getStatus() != ReadAckStatusType.UserStatusType.DELETED).collect(Collectors.toList()));
    }

    private Query buildQuery(ReadAckSearchCriteria searchCriteria) {
        String clause;
        Object clause2;
        String s;
        StringJoiner joiner;
        ArrayList<Object> values = new ArrayList<Object>();
        String queryClause = "";
        if (StringUtils.isNotBlank((CharSequence)searchCriteria.getUserKey())) {
            queryClause = "USER_KEY = ?";
            values.add(searchCriteria.getUserKey());
        } else if (searchCriteria.getUserKeys() != null && !searchCriteria.getUserKeys().isEmpty()) {
            joiner = new StringJoiner(",");
            for (String key : searchCriteria.getUserKeys()) {
                s = "?";
                joiner.add("?");
                values.add(key);
            }
            clause2 = "USER_KEY IN (" + joiner + ")";
            queryClause = queryClause + (String)(queryClause.isEmpty() ? clause2 : " AND " + (String)clause2);
        }
        if (searchCriteria.getPageId() != null) {
            clause = "PAGE_ID = ?";
            queryClause = queryClause + (queryClause.isEmpty() ? "PAGE_ID = ?" : " AND PAGE_ID = ?");
            values.add(searchCriteria.getPageId());
        } else if (searchCriteria.getPageIds() != null && !searchCriteria.getPageIds().isEmpty()) {
            joiner = new StringJoiner(",");
            for (Long pageId : searchCriteria.getPageIds()) {
                s = "?";
                joiner.add("?");
                values.add(pageId);
            }
            clause2 = "PAGE_ID IN (" + joiner + ")";
            queryClause = queryClause + (String)(queryClause.isEmpty() ? clause2 : " AND " + (String)clause2);
        }
        if (searchCriteria.getId() != null) {
            clause = "ID = ?";
            queryClause = queryClause + (queryClause.isEmpty() ? "ID = ?" : " AND ID = ?");
            values.add(searchCriteria.getPageId());
        } else if (searchCriteria.getIds() != null && !searchCriteria.getIds().isEmpty()) {
            joiner = new StringJoiner(",");
            for (Long fieldId : searchCriteria.getIds()) {
                s = "?";
                joiner.add("?");
                values.add(fieldId);
            }
            clause2 = "ID IN (" + joiner + ")";
            queryClause = queryClause + (String)(queryClause.isEmpty() ? clause2 : " AND " + (String)clause2);
        }
        if (searchCriteria.getPageStateId() != null) {
            clause = "PAGE_STATE_ID = ?";
            queryClause = queryClause + (queryClause.isEmpty() ? "PAGE_STATE_ID = ?" : " AND PAGE_STATE_ID = ?");
            values.add(searchCriteria.getPageStateId());
        }
        if (searchCriteria.getStatus() != null) {
            clause = "STATUS = ?";
            queryClause = queryClause + (queryClause.isEmpty() ? "STATUS = ?" : " AND STATUS = ?");
            values.add(searchCriteria.getStatus());
        } else if (CollectionUtils.isNotEmpty(searchCriteria.getStatusTypes())) {
            joiner = new StringJoiner(",");
            for (ReadAckStatusType.UserStatusType status : searchCriteria.getStatusTypes()) {
                s = "?";
                joiner.add("?");
                values.add(status);
            }
            clause2 = "STATUS IN (" + joiner + ")";
            queryClause = queryClause + (String)(queryClause.isEmpty() ? clause2 : " AND " + (String)clause2);
        }
        if (searchCriteria.getAssignmentType() != null) {
            clause = "ASSIGNMENT_TYPE = ?";
            queryClause = queryClause + (queryClause.isEmpty() ? "ASSIGNMENT_TYPE = ?" : " AND ASSIGNMENT_TYPE = ?");
            values.add(searchCriteria.getAssignmentType());
        }
        if (!queryClause.isEmpty()) {
            Query query = Query.select().where(queryClause, values.toArray());
            return query;
        }
        return null;
    }

    private Query applyFilters(ReadAckSearchFilter filter, Query query) {
        if (filter.getOrderBy() != null) {
            String orderClause = filter.getOrderBy().entrySet().stream().map(this::joinWithSpace).collect(Collectors.joining(","));
            query = query.order(orderClause);
        }
        if (filter.getOffset() >= 0) {
            query = query.offset(filter.getOffset());
        }
        if (filter.getLimit() > 0) {
            query = query.limit(filter.getLimit());
        }
        return query;
    }

    private String joinWithSpace(Map.Entry<String, String> entry) {
        return String.join((CharSequence)" ", entry.getKey(), entry.getValue());
    }
}

