/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.nextup.slack.infrastructure;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.comalatech.confluence.nextup.slack.infrastructure.SlackNotificationPublisher;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SlackUserMacro
extends AbstractActionMacro {
    private static final String PARAM_USER = "user";
    private static final String PARAM_SUBJECT = "subject";
    private SlackNotificationPublisher slackNotificationPublisher;
    @ComponentImport
    private UserAccessor userAccessor;
    @ComponentImport
    private GroupManager groupManager;

    @Override
    protected String getName() {
        return "send-slack-user";
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            String userGroupNames = (String)parameters.get(PARAM_USER);
            this.validateParamUser(userGroupNames);
            this.validateBody(body);
            if (!this.inExecuteMode(renderContext)) {
                return "";
            }
            AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
            ValueStore valueStore = this.getValueStore(renderContext);
            this.notifyUsers((String)parameters.get(PARAM_SUBJECT), body, userGroupNames, page, valueStore);
        }
        catch (Exception e) {
            if (this.inExecuteMode(renderContext)) {
                this.logMessage(renderContext, e);
                return "";
            }
            throw new MacroException(e.getMessage());
        }
        return "";
    }

    private void notifyUsers(String subject, String body, String usernames, AbstractPage pageId, ValueStore valueStore) throws WorkflowException {
        String replacedSubject = subject;
        if (StringUtils.isNotBlank((CharSequence)subject)) {
            replacedSubject = valueStore.replaceReferences(subject.trim());
        }
        String message = valueStore.replaceReferences(body.trim());
        CharSequence[] userKeys = this.usersListResolver.getValueAsUserKeys(valueStore, valueStore.getPage(), usernames);
        if (userKeys.length == 0) {
            throw new WorkflowUserException("There was a problem resolving the users or groups: [" + usernames + "].");
        }
        this.slackNotificationPublisher.publish(replacedSubject, message, String.join((CharSequence)",", userKeys), pageId);
    }

    private void validateParamUser(String usernames) throws MacroException, EntityException {
        String[] users;
        if (!StringUtils.isNotBlank((CharSequence)usernames)) {
            throw new MacroException("user must be defined.");
        }
        for (String user : users = MiscUtils.splitAndTrim(usernames)) {
            boolean isInvalidUser;
            if (user.startsWith("@") || user.endsWith("@")) continue;
            boolean isInvalidGroup = this.groupManager.getGroup(user) == null;
            boolean bl = isInvalidUser = this.userAccessor.getUserByName(user) == null;
            if (!isInvalidUser || !isInvalidGroup) continue;
            throw new MacroException("Invalid user or group " + user);
        }
    }

    private void validateBody(String body) throws MacroException {
        if (!StringUtils.isNotBlank((CharSequence)body)) {
            throw new MacroException("The body message must be defined.");
        }
    }

    public void setSlackNotificationPublisher(SlackNotificationPublisher slackNotificationPublisher) {
        this.slackNotificationPublisher = slackNotificationPublisher;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }
}

