/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.nextup.slack.infrastructure;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.notification.SlackNotificationConfigManager;
import com.comalatech.confluence.workflow.WorkflowsNotificationPublisher;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SlackNotificationPublisher
implements WorkflowsNotificationPublisher {
    private static final Logger log = LoggerFactory.getLogger(SlackNotificationPublisher.class);
    private static final String CDM_SLACK_USER_EVENT_EMITTER = "com.comalatech.confluence.SlackUserMessageRequested";
    private static final String PAYLOAD_VERSION = "user_v1";
    private final EventPublisher eventPublisher;
    private final SlackNotificationConfigManager slackNotificationConfigManager;

    public SlackNotificationPublisher(@ComponentImport EventPublisher eventPublisher, SlackNotificationConfigManager slackNotificationConfigManager) {
        this.eventPublisher = eventPublisher;
        this.slackNotificationConfigManager = slackNotificationConfigManager;
    }

    @Override
    public void publish(String subject, String message, String users, AbstractPage page) {
        if (this.slackNotificationConfigManager.isDisabledForSpace(page.getSpaceKey())) {
            log.debug("No slack message sent: slack notification not configured for this space: " + page.getSpaceKey());
            return;
        }
        if (this.slackNotificationConfigManager.isNextupPluginDisabled()) {
            log.warn("No slack message sent. The slack messages will not being sent until 'Docs+ Slack for Confluence' is enabled.");
            return;
        }
        Properties payload = new Properties();
        payload.setProperty("_emitter", CDM_SLACK_USER_EVENT_EMITTER);
        payload.setProperty("message", this.generateBlockKit(subject, this.convertWikiLinkToMarkdown(message)));
        payload.setProperty("users", users);
        payload.setProperty("page_id", String.valueOf(page.getId()));
        payload.setProperty("payload_version", PAYLOAD_VERSION);
        this.eventPublisher.publish((Object)payload);
    }

    private String generateBlockKit(String subject, String message) {
        JSONArray jsonBlockKit = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)subject)) {
            JSONObject subjectBlock = new JSONObject();
            subjectBlock.put("type", "header").put("text", new JSONObject().put("type", "plain_text").put("text", subject).put("emoji", true));
            jsonBlockKit.put(subjectBlock);
        }
        JSONObject messageBlock = new JSONObject();
        messageBlock.put("type", "section").put("block_id", "sectionBlockOnlyMrkdwn").put("text", new JSONObject().put("type", "mrkdwn").put("text", message));
        jsonBlockKit.put(messageBlock);
        return jsonBlockKit.toString();
    }

    private int containsWikiLinkAtIndex(String text, int start) {
        String possibleWikiLink;
        int end;
        int index = text.indexOf(91, start);
        if (index > -1 && (end = text.indexOf(93, index)) > -1 && !(possibleWikiLink = text.substring(index, end + 1)).contains("|")) {
            return this.containsWikiLinkAtIndex(text, start + index);
        }
        return index;
    }

    private String replaceWikiLinkAt(String text, int start) {
        int end = text.indexOf(93, start + 1);
        String wikiLink = text.substring(start, end + 1);
        String linkText = text.substring(start + 1, text.indexOf(124, start));
        String url = text.substring(text.indexOf(124, start) + 1, end);
        String markdown = "<" + url + "|" + linkText + ">";
        return text.replace(wikiLink, markdown);
    }

    private String convertWikiLinkToMarkdown(String message) {
        String result = message;
        int index = this.containsWikiLinkAtIndex(result, 0);
        while (index > -1) {
            result = this.replaceWikiLinkAt(result, index);
            index = this.containsWikiLinkAtIndex(result, index + 1);
        }
        return result;
    }
}

