/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.ipc.MetadataLookup;
import com.comalatech.confluence.ipc.StatesLookup;
import com.comalatech.confluence.ipc.WorkflowReporterBugFixer;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.AssignableActivity;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.Approval;
import com.comalatech.workflow.model.Assignment;
import com.servicerocket.confluence.randombits.supplier.core.annotate.AnnotatedSupplier;
import com.servicerocket.confluence.randombits.supplier.core.annotate.KeyParam;
import com.servicerocket.confluence.randombits.supplier.core.annotate.KeyValue;
import com.servicerocket.confluence.randombits.supplier.core.annotate.SupplierKey;
import com.servicerocket.confluence.randombits.supplier.core.annotate.SupplierPrefix;
import com.servicerocket.confluence.randombits.supplier.core.annotate.SupportedTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupplierPrefix(value={"workflow"})
@SupportedTypes(value={AbstractPage.class, PageTask.class, PageState.class, ApprovalCheck.class, MetadataLookup.class, TaskCompletion.class, StatesLookup.class, com.comalatech.confluence.states.model.Assignment.class})
public class AdhocWorkflowsAnnotatedSupplier
extends AnnotatedSupplier {
    private static final Logger log = LoggerFactory.getLogger(AdhocWorkflowsAnnotatedSupplier.class);
    private final StateAccessor stateAccessor;
    private final StateService stateService;
    private final ApprovalAccessor approvalAccessor;
    private final UserAccessor userAccessor;
    private final InternalWorkflowParameterManager workflowParameterManager;
    private final UsersListResolver usersListResolver;

    public AdhocWorkflowsAnnotatedSupplier(StateAccessor stateAccessor, StateService stateService, ApprovalAccessor approvalAccessor, UserAccessor userAccessor, InternalWorkflowParameterManager workflowParameterManager, UsersListResolver usersListResolver) {
        this.stateAccessor = stateAccessor;
        this.stateService = stateService;
        this.approvalAccessor = approvalAccessor;
        this.userAccessor = userAccessor;
        this.workflowParameterManager = workflowParameterManager;
        this.usersListResolver = usersListResolver;
    }

    @SupplierKey(value={"{key}"})
    public Object getMetadataValue(@KeyParam(value="key") String key, @KeyValue MetadataLookup lookup) {
        return this.workflowParameterManager.getParameterValue(lookup.page, key);
    }

    @SupplierKey(value={"tasks", "activetasks"})
    public List<PageTask> getActiveTasks(@KeyValue PageState state) {
        return state.getPageTasks().getActiveTasks();
    }

    @SupplierKey(value={"completedtasks"})
    public List<PageTask> getCompletedTasks(@KeyValue PageState state) {
        return state.getPageTasks().getCompletedTasks();
    }

    @SupplierKey(value={"alltasks"})
    public List<PageTask> getAllTasks(@KeyValue PageState state) {
        return state.getPageTasks().get();
    }

    @SupplierKey(value={"version"})
    public int getVersion(@KeyValue PageState state) {
        return state.getVersion();
    }

    @SupplierKey(value={"duedate"})
    public Date getDueDateLegacy(@KeyValue PageState state) {
        return state.getExpirationDate();
    }

    @SupplierKey(value={"expirydate"})
    public Date getExpiryDate(@KeyValue PageState state) {
        return state.getExpirationDate();
    }

    @SupplierKey(value={"allapprovals"})
    public Collection<ApprovalCheck> getAllApprovals(@KeyValue PageState state) {
        return this.approvalAccessor.getApprovalChecks(state.getPage(), state);
    }

    @SupplierKey(value={"completed"})
    public boolean isCompleted(@KeyValue PageTask task) {
        return task.isCompleted();
    }

    @SupplierKey(value={"completion"})
    public TaskCompletion getLastTaskCompletion(@KeyValue PageTask task) {
        return task.getLastCompletion();
    }

    @SupplierKey(value={"completions"})
    public Collection<TaskCompletion> getTaskCompletions(@KeyValue PageTask task) {
        return task.getCompletions();
    }

    @SupplierKey(value={"duedate"})
    public Date getTaskDueDate(@KeyValue PageTask task) {
        return task.getDueDate();
    }

    @SupplierKey(value={"outcome"})
    public String getCompletionOutcome(@KeyValue TaskCompletion completion) {
        return completion.getOutcome();
    }

    @SupplierKey(value={"approved"})
    public boolean isCompletionApproved(@KeyValue TaskCompletion completion) {
        return "approve".equals(completion.getOutcome());
    }

    @SupplierKey(value={"rejected"})
    public boolean isCompletionRejected(@KeyValue TaskCompletion completion) {
        return "approve".equals(completion.getOutcome());
    }

    @SupplierKey(value={"name", "state"})
    public String getName(@KeyValue AssignableActivity activity) {
        return activity.getName();
    }

    @SupplierKey(value={"assignee"})
    public ConfluenceUser getAssignee(@KeyValue AssignableActivity activity) {
        com.comalatech.confluence.states.model.Assignment assignment = activity.getLastAssignment();
        if (assignment == null || !StringUtils.isNotBlank((CharSequence)assignment.getAssigneeNames())) {
            return null;
        }
        String[] names = MiscUtils.splitAndTrim(assignment.getAssigneeNames());
        return this.userAccessor.getUserByName(names[0]);
    }

    @SupplierKey(value={"assignees"})
    public Collection<ConfluenceUser> getAssignees(@KeyValue AssignableActivity activity) {
        com.comalatech.confluence.states.model.Assignment assignment = activity.getLastAssignment();
        if (assignment == null || !StringUtils.isNotBlank((CharSequence)assignment.getAssigneeNames())) {
            return null;
        }
        return this.usersListResolver.getAsUsers(assignment.getAssigneeNames());
    }

    @SupplierKey(value={"assignment"})
    public com.comalatech.confluence.states.model.Assignment getLastAssignment(@KeyValue AssignableActivity activity) {
        return activity.getLastAssignment();
    }

    @SupplierKey(value={"assignments"})
    public Collection<com.comalatech.confluence.states.model.Assignment> getAssignments(@KeyValue AssignableActivity activity) {
        return activity.getAssignments();
    }

    @SupplierKey(value={"user"})
    public ConfluenceUser getActivityUser(@KeyValue Activity activity) {
        return this.userAccessor.getUserByName(activity.getPerformer());
    }

    @SupplierKey(value={"date"})
    public Date getActivityDate(@KeyValue Activity activity) {
        return activity.getDate();
    }

    @SupplierKey(value={"comment"})
    public String getComment(@KeyValue Activity activity) {
        return activity.getComment();
    }

    @SupplierKey(value={"name"})
    public String getName(@KeyValue ApprovalCheck approval) {
        return approval.getName();
    }

    @SupplierKey(value={"approved"})
    public boolean isApproved(@KeyValue ApprovalCheck approval) {
        return approval.isApproved();
    }

    @SupplierKey(value={"rejected"})
    public boolean isRejected(@KeyValue ApprovalCheck approval) {
        return approval.isRejected(true);
    }

    @SupplierKey(value={"version"})
    public int getVersion(@KeyValue ApprovalCheck approval) {
        return approval.getVersion();
    }

    @SupplierKey(value={"date"})
    public Date getDate(@KeyValue ApprovalCheck approval) {
        Approver lastApprover = approval.getLastApprover();
        return lastApprover == null ? null : lastApprover.getDate();
    }

    @SupplierKey(value={"comment"})
    public String getComment(@KeyValue ApprovalCheck approval) {
        Approver lastApprover = approval.getLastApprover();
        return lastApprover == null ? null : lastApprover.getComment();
    }

    @SupplierKey(value={"assignees"})
    public Collection<ConfluenceUser> getAssignees(@KeyValue ApprovalCheck approvalCheck) {
        CharSequence[] requiredUsers = approvalCheck.getRequiredApprovers();
        return this.usersListResolver.getAsUsers(String.join((CharSequence)",", requiredUsers));
    }

    @SupplierKey(value={"assignee"})
    public ConfluenceUser getAssignee(@KeyValue ApprovalCheck approvalCheck) {
        Assignment assignment = approvalCheck.getLastAssignment();
        if (assignment == null || !StringUtils.isNotBlank((CharSequence)assignment.getAssignee())) {
            return null;
        }
        return this.userAccessor.getUserByName(assignment.getAssignee());
    }

    @SupplierKey(value={"user"})
    public ConfluenceUser getUser(@KeyValue ApprovalCheck approval) {
        Approver lastApprover = approval.getLastApprover();
        return lastApprover == null ? null : this.userAccessor.getUserByName(lastApprover.getUser());
    }

    @SupplierKey(value={"users", "approvers"})
    public List<ConfluenceUser> getUsers(@KeyValue ApprovalCheck approval) {
        ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
        for (Approval userApproval : approval.getApprovals()) {
            ConfluenceUser user = this.userAccessor.getUserByName(userApproval.getPerformer());
            users.add(user);
        }
        return users;
    }

    @SupplierKey(value={"{key}"})
    public List<PageState> getStates(@KeyValue StatesLookup statesLookup, @KeyParam(value="key") String key) {
        ArrayList<PageState> states = new ArrayList<PageState>();
        if (key.equalsIgnoreCase("all")) {
            states.addAll(statesLookup.states);
        }
        for (PageState pageState : statesLookup.states) {
            if (!pageState.getName().equalsIgnoreCase(key)) continue;
            states.add(pageState);
        }
        return states;
    }

    @SupplierKey(value={"approvals"})
    public Collection<ApprovalCheck> getApprovalChecks(@KeyValue AbstractPage page) {
        return this.approvalAccessor.getLatestApprovalChecks(page);
    }

    @SupplierKey(value={"state"})
    public PageState getState(@KeyValue AbstractPage page) {
        return (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
    }

    @SupplierKey(value={"states"})
    public StatesLookup getStates(@KeyValue AbstractPage page) {
        if (page.getId() == WorkflowReporterBugFixer.HARDCODED_STATES_ID.longValue()) {
            log.info("supplier returning hard coded states for page: " + page);
            ArrayList<PageState> hardcodedstates = new ArrayList<PageState>();
            hardcodedstates.add(new PageState("Mock State"));
            return new StatesLookup(hardcodedstates);
        }
        return new StatesLookup(this.stateAccessor.getPageStates(page));
    }

    @SupplierKey(value={"tasks"})
    public Collection<PageTask> getTasks(@KeyValue AbstractPage page) {
        PageState pageState = this.stateAccessor.getLatestState(page);
        if (pageState != null) {
            return pageState.getPageTasks().getActiveTasks();
        }
        return new ArrayList<PageTask>();
    }

    @SupplierKey(value={"metadata"})
    public MetadataLookup getMetadata(@KeyValue AbstractPage page) {
        return new MetadataLookup(page);
    }
}

