/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.ao.ActivityDeleteCriteria;
import com.comalatech.confluence.documentActivity.ao.ActivityDetailsDeleteCriteria;
import com.comalatech.confluence.documentActivity.ao.ActivitySearchCriteria;
import com.comalatech.confluence.documentActivity.ao.ActivityUpdateCriteria;
import com.comalatech.confluence.documentActivity.ao.accesor.ActivityDetailsRecordAccessor;
import com.comalatech.confluence.documentActivity.ao.accesor.ActivityRecordAccessor;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityDetailsRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordOrigin;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityDetailsRecord;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityRecord;
import com.comalatech.confluence.documentActivity.ao.mapper.ActivityRecordMapper;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityResult;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityResultMetadata;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.provider.ActivityProvider;
import com.comalatech.confluence.documentActivity.service.provider.ComalaActivityProvider;
import com.comalatech.confluence.documentActivity.service.provider.PageCommentsActivityProvider;
import com.comalatech.confluence.documentActivity.service.provider.PageEditsActivityProvider;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import com.comalatech.workflow.model.document.activity.SortingOrder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DocumentActivityServiceImpl
implements DocumentActivityService {
    private static final Logger log = LoggerFactory.getLogger(DocumentActivityServiceImpl.class);
    private final ActivityRecordAccessor activityRecordAccessor;
    private final ActivityDetailsRecordAccessor activityDetailsRecordAccessor;
    private final ActivityRecordMapper activityRecordMapper;
    private final TransactionalHostContextAccessor transactionalHostContextAccessor;
    private final List<ActivityProvider> allActivityProviders;
    private final ActivityProvider workflowsProvider;
    private final DarkFeatureManager darkFeatureManager;
    private final PageManager pageManager;
    private final ActorUtils actorUtils;

    public DocumentActivityServiceImpl(ActivityRecordAccessor activityRecordAccessor, ActivityDetailsRecordAccessor activityDetailsRecordAccessor, @ComponentImport UserAccessor userAccessor, @ComponentImport TransactionalHostContextAccessor transactionalHostContextAccessor, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, WorkflowUserAccessor workflowUserAccessor, @ComponentImport DarkFeatureManager darkFeatureManager, @ComponentImport PageManager pageManager) {
        this.activityRecordAccessor = activityRecordAccessor;
        this.activityDetailsRecordAccessor = activityDetailsRecordAccessor;
        this.transactionalHostContextAccessor = transactionalHostContextAccessor;
        this.darkFeatureManager = darkFeatureManager;
        this.pageManager = pageManager;
        this.actorUtils = new ActorUtils(userAccessor, workflowUserAccessor);
        this.activityRecordMapper = new ActivityRecordMapper(this.actorUtils);
        this.workflowsProvider = new ComalaActivityProvider(activityRecordAccessor, this.actorUtils);
        this.allActivityProviders = Arrays.asList(new PageEditsActivityProvider(contentEntityManager, this.actorUtils), new PageCommentsActivityProvider(contentEntityManager, this.actorUtils), this.workflowsProvider);
    }

    @Override
    public void create(Activity activity, ActivityRecordOrigin origin) {
        if (ActivityRecordOrigin.ORIGIN_EVENT.equals((Object)origin)) {
            this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRES_NEW, TransactionalHostContextAccessor.Permission.READ_WRITE, () -> {
                this.save(activity, origin);
                return null;
            });
        } else if (ActivityRecordOrigin.ORIGIN_UPGRADE.equals((Object)origin)) {
            this.save(activity, origin);
        }
    }

    @Override
    public void create(Activity activity) {
        this.create(activity, ActivityRecordOrigin.ORIGIN_EVENT);
    }

    @Override
    public DocumentActivityResult get(InternalDocumentActivityQuery query) {
        return this.get(query, true);
    }

    private DocumentActivityResult get(InternalDocumentActivityQuery query, boolean isInternalQuery) {
        if (query == null || query.getFilters() == null) {
            throw new IllegalArgumentException("Invalid query data received. Empty query or empty filters received");
        }
        List<ActivityProvider> providers = isInternalQuery ? this.allActivityProviders : Collections.singletonList(this.workflowsProvider);
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (ActivityProvider activityProvider : providers) {
            if (!this.darkFeatureManager.isEnabledForAllUsers("comalatech.workflows.show.page.inline-comments").orElse(false).booleanValue() && activityProvider instanceof PageCommentsActivityProvider) continue;
            activities.addAll(activityProvider.get(query));
        }
        activities.forEach(this::replaceActivityTargetVersion);
        Comparator sortingComparator = SortingOrder.asc == query.getOrder() ? Comparator.naturalOrder() : Comparator.reverseOrder();
        activities.sort(sortingComparator);
        List<Activity> truncatedActivities = activities.subList(0, this.getLimitCheckingUniqueLatestActivity(activities, query));
        boolean hasMoreResults = false;
        Long nextActivityTimestamp = null;
        if (truncatedActivities.size() < activities.size()) {
            hasMoreResults = true;
            nextActivityTimestamp = ((Activity)activities.get(truncatedActivities.size())).getMoment();
        }
        return DocumentActivityResult.builder().activities(truncatedActivities).metadata(DocumentActivityResultMetadata.builder().hasMoreResults(hasMoreResults).resultSize(truncatedActivities.size()).nextActivityTimestamp(nextActivityTimestamp).build()).build();
    }

    @Override
    public DocumentActivityResult getPublicActivity(InternalDocumentActivityQuery query) {
        return this.get(query, false);
    }

    private int getLimitCheckingUniqueLatestActivity(List<Activity> activities, InternalDocumentActivityQuery query) {
        if (query.getLimit() == 0) {
            return 0;
        }
        if (activities.size() < query.getLimit()) {
            return activities.size();
        }
        int marker = query.getLimit() - 1;
        long limitTimestamp = activities.get(marker).getMoment();
        while (activities.size() > ++marker && limitTimestamp == activities.get(marker).getMoment()) {
        }
        return marker;
    }

    @Override
    public void delete(Long contentId) {
        this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRES_NEW, TransactionalHostContextAccessor.Permission.READ_WRITE, () -> {
            Object activitySearchCriteria = ((ActivitySearchCriteria.ActivitySearchCriteriaBuilder)ActivitySearchCriteria.builder().contentId(contentId)).build();
            List<BaseActivityRecord> activityRecords = this.activityRecordAccessor.search((ActivitySearchCriteria)activitySearchCriteria);
            for (BaseActivityRecord activityRecord : activityRecords) {
                List<ActivityDetailsRecordEntity> activityDetails;
                if (activityRecord.getActivityDetails() == null || (activityDetails = Arrays.asList(activityRecord.getActivityDetails())).isEmpty()) continue;
                ActivityDetailsDeleteCriteria activityDetailsDeleteCriteria = new ActivityDetailsDeleteCriteria();
                activityDetailsDeleteCriteria.setActivityId(activityDetails.get(0).getActivity().getId());
                this.activityDetailsRecordAccessor.delete(activityDetailsDeleteCriteria);
            }
            ActivityDeleteCriteria eventDeleteCriteria = new ActivityDeleteCriteria();
            eventDeleteCriteria.setContentId(contentId);
            this.activityRecordAccessor.delete(eventDeleteCriteria);
            return null;
        });
    }

    @Override
    public List<BaseActivityRecord> getById(AbstractPage page) {
        Object activitySearchCriteria = ((ActivitySearchCriteria.ActivitySearchCriteriaBuilder)ActivitySearchCriteria.builder().contentId(page.getId())).build();
        return this.activityRecordAccessor.search((ActivitySearchCriteria)activitySearchCriteria);
    }

    @Override
    public void update(Long contentId, Long targetSpaceId) {
        ActivityUpdateCriteria update = new ActivityUpdateCriteria(contentId, targetSpaceId);
        this.activityRecordAccessor.update(update);
    }

    private void replaceActivityTargetVersion(Activity activity) {
        ContentEntityObject contentOtherVersion;
        AbstractPage content = this.pageManager.getAbstractPage(activity.getTarget().getTargetId());
        if (content != null && (contentOtherVersion = this.pageManager.getOtherVersion((ContentEntityObject)content, activity.getTarget().getTargetVersion())) != null) {
            activity.getTarget().setTargetId(contentOtherVersion.getId());
        }
    }

    private void save(Activity activity, ActivityRecordOrigin origin) {
        BaseActivityRecord activityRecord = null;
        try {
            activityRecord = this.activityRecordMapper.activityToRecord(activity, origin);
        }
        catch (IOException e) {
            log.error("Error mapping the activity.", (Throwable)e);
        }
        ActivityRecordEntity activityRecordEntity = this.activityRecordAccessor.create(activityRecord);
        List<BaseActivityDetailsRecord> activityDetailsRecords = this.activityRecordMapper.activityToDetailRecord(activity, activityRecordEntity);
        for (BaseActivityDetailsRecord activityDetailsRecord : activityDetailsRecords) {
            this.activityDetailsRecordAccessor.create(activityDetailsRecord);
        }
    }
}

