/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.rest.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowVisibilityPermissionsRequired;
import com.comalatech.confluence.documentActivity.rest.model.DocumentActivityReportRequest;
import com.comalatech.confluence.documentActivity.rest.validator.RequestValidator;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityResult;
import com.comalatech.confluence.util.validators.PermissionValidator;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/report/documentactivities")
@Produces(value={"application/json"})
public class DocumentActivityReportResource {
    private static final Logger log = LoggerFactory.getLogger(DocumentActivityReportResource.class);
    private final DocumentActivityService documentActivityService;
    private final RequestValidator requestValidator;
    private final PermissionValidator permissionValidator;

    public DocumentActivityReportResource(DocumentActivityService documentActivityService, @Qualifier(value="permissionValidator") PermissionValidator permissionValidator) {
        this.documentActivityService = documentActivityService;
        this.requestValidator = new RequestValidator();
        this.permissionValidator = permissionValidator;
    }

    @POST
    @WorkflowVisibilityPermissionsRequired
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=200, message="Activities were queried successfully"), @ApiResponse(code=400, message="Validation error of the input body"), @ApiResponse(code=401, message="Client is not authenticated"), @ApiResponse(code=403, message="User has not workflow visibility permissions"), @ApiResponse(code=500, message="Exception when trying to retrieve data for DocumentActivity")})
    public Response getReportForPage(DocumentActivityReportRequest request) {
        try {
            this.requestValidator.validateTarget(request);
            this.requestValidator.validatePages(request.getFilters().getScope());
            Collection<Annotation> allAnnotations = new PermissionValidator.AnnotationGetterCommand(){}.getAllAnnotations();
            this.permissionValidator.validatePages(allAnnotations, request.getFilters().getScope().getPageIds());
            DocumentActivityResult result = this.documentActivityService.get(request.toQuery());
            return Response.ok((Object)result).build();
        }
        catch (IllegalArgumentException e) {
            String warningMsg = MessageFormat.format("Input validation error. The request: {0} caused this error: {1}", request, e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ApplicationPermissionException e) {
            String warningMsg = MessageFormat.format("Permission validation error. {0} ", e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format("Unable to retrieve data for DocumentActivityReport for this request: {0}", request);
            log.error(errorMsg, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

