/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.mapper;

import com.comalatech.confluence.documentActivity.ao.entity.ActivityDetailsRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordOrigin;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityDetailsRecord;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityDetailsRecordImpl;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityRecord;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityRecordImpl;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.domain.entities.Target;
import com.comalatech.confluence.documentActivity.domain.entities.TargetAttachment;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.license.ComalaDocumentAppManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.WorkflowUserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityRecordMapper {
    private static final Logger log = LoggerFactory.getLogger(ActivityRecordMapper.class);
    private static final List<ActionDetailType> DETAILS_PRESENT_IN_RECORD = Arrays.asList(ActionDetailType.IS_PUBLISHED, ActionDetailType.STATE_ID, ActionDetailType.STATE_NAME);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ActorUtils actorUtils;

    public ActivityRecordMapper(ActorUtils actorUtils) {
        this.actorUtils = actorUtils;
    }

    public BaseActivityRecord activityToRecord(Activity activity, ActivityRecordOrigin origin) throws IOException {
        BaseActivityRecordImpl activityRecord = new BaseActivityRecordImpl(activity.getMoment(), activity.getAction().getActors().get(0).getId(), activity.getTarget().getTargetId(), activity.getTarget().getTargetVersion(), activity.getTarget().getSpaceId(), activity.getAction().getActionType().getType().toString(), activity.getAction().getActionType().getSubtype().toString());
        List<TargetAttachment> attachments = activity.getTarget().getAttachmentList();
        if (attachments != null && !attachments.isEmpty()) {
            String attachmentsStr = this.objectMapper.writeValueAsString(attachments);
            activityRecord.setTargetAttachments(attachmentsStr);
        }
        ActionDetails actionDetails = activity.getAction().getActionDetails();
        activityRecord.setFinalVersion(Boolean.valueOf(actionDetails.getDetailValue(ActionDetailType.IS_PUBLISHED)));
        activityRecord.setStateId(actionDetails.getDetailValue(ActionDetailType.STATE_ID) != null ? Long.valueOf(actionDetails.getDetailValue(ActionDetailType.STATE_ID)) : null);
        activityRecord.setStateName(actionDetails.getDetailValue(ActionDetailType.STATE_NAME));
        activityRecord.setOrigin(origin.getValue());
        activityRecord.setAppVersion(this.getComalaDocumentAppManager().getAppInfo());
        return activityRecord;
    }

    public List<BaseActivityDetailsRecord> activityToDetailRecord(Activity activity, ActivityRecordEntity activityRecordEntity) {
        ArrayList<BaseActivityDetailsRecord> activityDetailsRecords = new ArrayList<BaseActivityDetailsRecord>();
        ActionDetails actionDetails = activity.getAction().getActionDetails();
        if (actionDetails != null) {
            activityDetailsRecords.addAll(actionDetails.stream().filter(actionDetail -> !this.isDetailPresentInRecord(actionDetail.getType())).map(actionDetail -> this.createDetailsRecord((ActionDetail)actionDetail, activityRecordEntity)).collect(Collectors.toList()));
        }
        return activityDetailsRecords;
    }

    public Activity recordToActivity(BaseActivityRecord activityRecord) throws IOException, WorkflowUserException {
        if (activityRecord == null) {
            return null;
        }
        Target target = new Target();
        target.setTargetId(activityRecord.getPageId());
        target.setTargetVersion(activityRecord.getPageVersion());
        target.setSpaceId(activityRecord.getSpaceId());
        if (!StringUtils.isEmpty((CharSequence)activityRecord.getTargetAttachments())) {
            List<TargetAttachment> attachments = Arrays.asList((TargetAttachment[])this.objectMapper.readValue(activityRecord.getTargetAttachments(), TargetAttachment[].class));
            target.setAttachmentList(attachments);
        }
        ActionType actionType = new ActionType(ActionType.Type.fromString(activityRecord.getActionType()), ActionType.Subtype.fromString(activityRecord.getActionSubtype()));
        ActionDetails actionDetails = this.recordDetailsToActivity(activityRecord);
        actionDetails.addDetail(ActionDetailType.IS_PUBLISHED, activityRecord.isFinalVersion().toString());
        actionDetails.addDetail(ActionDetailType.STATE_NAME, activityRecord.getStateName());
        actionDetails.addDetail(ActionDetailType.STATE_ID, activityRecord.getStateId() != null ? activityRecord.getStateId().toString() : null);
        Actor actor = this.actorUtils.buildActorWithKey(activityRecord.getActorId());
        Action action = new Action(actionType, actor, actionDetails);
        return new Activity(target, activityRecord.getMoment(), action);
    }

    private ActionDetails recordDetailsToActivity(BaseActivityRecord activityRecord) {
        ActionDetails actionDetails = new ActionDetails();
        if (activityRecord.getActivityDetails() != null) {
            List<ActivityDetailsRecordEntity> activityDetailsRecords = Arrays.asList(activityRecord.getActivityDetails());
            activityDetailsRecords.forEach(activityDetail -> {
                try {
                    ActionDetailType type = ActionDetailType.fromString(activityDetail.getType());
                    ArrayList<Actor> actors = new ArrayList<Actor>();
                    if (ActionDetail.isParticipantType(type)) {
                        for (String userKey : activityDetail.getValue().split(",")) {
                            actors.add(this.actorUtils.buildActorWithKey(userKey));
                        }
                    }
                    actionDetails.addDetail(type, activityDetail.getValue(), null, actors.isEmpty() ? null : actors);
                }
                catch (WorkflowUserException e) {
                    log.error("Cannot build user for activity participant", (Throwable)e);
                }
            });
        }
        return actionDetails;
    }

    private boolean isDetailPresentInRecord(ActionDetailType type) {
        return DETAILS_PRESENT_IN_RECORD.contains((Object)type);
    }

    private BaseActivityDetailsRecord createDetailsRecord(ActionDetail actionDetail, ActivityRecordEntity activityRecordEntity) {
        return new BaseActivityDetailsRecordImpl(actionDetail.getType().toString(), actionDetail.getValue(), actionDetail.getKey(), activityRecordEntity);
    }

    private ComalaDocumentAppManager getComalaDocumentAppManager() {
        return PluginContainerManager.getComponent(ComalaDocumentAppManager.class);
    }
}

