/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.repository;

import com.atlassian.migration.app.check.CheckResult;
import com.atlassian.migration.app.check.CheckResultBuilder;
import com.atlassian.migration.app.check.CheckSpec;
import com.atlassian.migration.app.check.CheckStatus;
import com.atlassian.migration.app.check.Container;
import com.atlassian.migration.app.check.CsvFileContent;
import com.atlassian.migration.app.check.MigrationPlanContext;
import com.atlassian.migration.app.check.PreMigrationCheckRepository;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ValidatePreFlightCheck;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflow.accesor.entity.ContentActivityCSVWorkflowRecord;
import com.comalatech.confluence.workflow.accesor.entity.ContentRestrictionWorkflowRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DocumentManagementPreCheckRepository
implements PreMigrationCheckRepository {
    private static final Logger log = LoggerFactory.getLogger(DocumentManagementPreCheckRepository.class);
    private static final String COMALA_CHECK_KEY = "comalatech.migration.preflight.";
    private static final String RESTRICTIONS_CHECK = "restrictions";
    private static final String ATTACH_CSV_CHECK = "activity";
    private static final String RESTRICTIONS_STEP_TO_RESOLVE_RESTRICTIONS_WARNING = "steps-to-resolve-restrictions-found";
    private static final String RESTRICTIONS_STEP_TO_RESOLVE_RESTRICTIONS_ERROR = "steps-to-resolve-restrictions-error";
    private static final String RESTRICTIONS_STEP_TO_RESOLVE_CSV_ATTACHMENTS_WARNING = "steps-to-resolve-csv-attachments-found";
    private static final String RESTRICTIONS_STEP_TO_RESOLVE_CSV_ATTACHMENTS_ERROR = "steps-to-resolve-csv-attachments-error";
    private final ValidatePreFlightCheck validatePreFlightCheck;
    private final ComalaI18nBean comalaI18nBean;

    public DocumentManagementPreCheckRepository(ValidatePreFlightCheck validatePreFlightCheck, ComalaI18nBean comalaI18nBean) {
        this.validatePreFlightCheck = validatePreFlightCheck;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public Set<CheckSpec> getAvailableChecks() {
        HashSet<CheckSpec> checks = new HashSet<CheckSpec>();
        try {
            checks.add(this.createRestrictionsCheck());
            checks.add(this.createCSVAttachmentsCheck());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return checks;
    }

    @Override
    public CheckResult executeCheck(String checkId, MigrationPlanContext migrationPlanContext) {
        log.info("Running checks for plan {}", (Object)migrationPlanContext.getPlanName());
        log.info("Context of the migration: {}", (Object)Arrays.toString(migrationPlanContext.getContainers().toArray()));
        switch (checkId) {
            case "restrictions": {
                return this.checkContentRestrictions(migrationPlanContext.getContainers());
            }
            case "activity": {
                return this.checkCSVAttachments(migrationPlanContext.getContainers());
            }
        }
        throw new IllegalStateException("Unknown check: " + checkId);
    }

    private CheckSpec createRestrictionsCheck() {
        CheckSpec restrictionsCheck = new CheckSpec(RESTRICTIONS_CHECK, this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.title"), this.buildStepsToResolveRestrictionsTemplates());
        List<String> validationErrors = restrictionsCheck.validate();
        if (!validationErrors.isEmpty()) {
            log.warn("Validation errors found: " + validationErrors);
        }
        return restrictionsCheck;
    }

    private CheckSpec createCSVAttachmentsCheck() {
        CheckSpec activityAttachmentCheck = new CheckSpec(ATTACH_CSV_CHECK, this.comalaI18nBean.getText("comalatech.migration.preflight.activity.check.title"), this.buildStepsToResolveCSVAttachmentsTemplates());
        List<String> validationErrors = activityAttachmentCheck.validate();
        if (!validationErrors.isEmpty()) {
            log.warn("Validation errors found: " + validationErrors);
        }
        return activityAttachmentCheck;
    }

    private CheckResult checkContentRestrictions(Set<Container> containers) {
        try {
            CheckResultBuilder builder = CheckResultBuilder.resultBuilder(CheckStatus.SUCCESS);
            List<String> spaceKeys = containers.stream().map(Container::getId).collect(Collectors.toList());
            List<ContentRestrictionWorkflowRecord> records = this.validatePreFlightCheck.getContentWithRestrictions(spaceKeys);
            if (!records.isEmpty()) {
                CsvFileContent csvFile = this.generateRestrictionsCSVFile(records);
                builder = CheckResultBuilder.resultBuilder(CheckStatus.WARNING);
                builder.withStepsToResolveKey(RESTRICTIONS_STEP_TO_RESOLVE_RESTRICTIONS_WARNING);
                builder.withCsvFileContent(csvFile);
            }
            return builder.build();
        }
        catch (Exception e) {
            log.error("checkContentRestrictions - Exception: {}", (Object)e.getMessage(), (Object)e);
            return CheckResultBuilder.resultBuilder(CheckStatus.CHECK_EXECUTION_ERROR).withStepsToResolveKey(RESTRICTIONS_STEP_TO_RESOLVE_RESTRICTIONS_ERROR).build();
        }
    }

    private CheckResult checkCSVAttachments(Set<Container> containers) {
        try {
            CheckResultBuilder builder = CheckResultBuilder.resultBuilder(CheckStatus.SUCCESS);
            List<String> spaceKeys = containers.stream().map(Container::getId).collect(Collectors.toList());
            List<ContentActivityCSVWorkflowRecord> spaceKeysWithNoCSV = this.validatePreFlightCheck.getContentWithNoCSVAttachment(spaceKeys);
            if (!spaceKeysWithNoCSV.isEmpty()) {
                CsvFileContent csvFile = this.generateActivityCSVFile(spaceKeysWithNoCSV);
                builder = CheckResultBuilder.resultBuilder(CheckStatus.WARNING);
                builder.withStepsToResolveKey(RESTRICTIONS_STEP_TO_RESOLVE_CSV_ATTACHMENTS_WARNING);
                builder.withCsvFileContent(csvFile);
            }
            return builder.build();
        }
        catch (Exception e) {
            log.error("checkContentRestrictions - Exception: {}", (Object)e.getMessage(), (Object)e);
            return CheckResultBuilder.resultBuilder(CheckStatus.CHECK_EXECUTION_ERROR).withStepsToResolveKey(RESTRICTIONS_STEP_TO_RESOLVE_CSV_ATTACHMENTS_ERROR).build();
        }
    }

    private Map<String, String> buildStepsToResolveRestrictionsTemplates() {
        HashMap<String, String> stepsToResolve = new HashMap<String, String>();
        stepsToResolve.put(RESTRICTIONS_STEP_TO_RESOLVE_RESTRICTIONS_WARNING, "<paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.warning.paragraph") + "</> <ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.warning.orderedItem1") + "</><ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.warning.orderedItem2") + "</><ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.warning.orderedItem3") + "</><ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.warning.orderedItem4") + "</>");
        stepsToResolve.put(RESTRICTIONS_STEP_TO_RESOLVE_RESTRICTIONS_ERROR, "<paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.error.paragraph") + "</>");
        return stepsToResolve;
    }

    private Map<String, String> buildStepsToResolveCSVAttachmentsTemplates() {
        HashMap<String, String> stepsToResolve = new HashMap<String, String>();
        stepsToResolve.put(RESTRICTIONS_STEP_TO_RESOLVE_CSV_ATTACHMENTS_WARNING, "<paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.activity.check.warning.paragraph") + "</> <ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.activity.check.warning.orderedItem1") + "</><ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.activity.check.warning.orderedItem2") + "</><ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.activity.check.warning.orderedItem3") + "</><ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.activity.check.warning.orderedItem4") + "</>");
        stepsToResolve.put(RESTRICTIONS_STEP_TO_RESOLVE_CSV_ATTACHMENTS_ERROR, "<paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.activity.check.error.paragraph") + "</>");
        return stepsToResolve;
    }

    private CsvFileContent generateCSVHeaders(String key, int elements) {
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 1; i <= elements; ++i) {
            headers.add(this.comalaI18nBean.getText(COMALA_CHECK_KEY + key + ".check.csv.header" + i));
        }
        return new CsvFileContent(headers);
    }

    private CsvFileContent generateRestrictionsCSVContent(CsvFileContent csvFileContent, List<ContentRestrictionWorkflowRecord> records) {
        Map<String, Map<Long, Map<String, Map<Optional, List<ContentRestrictionWorkflowRecord>>>>> groupByContent = records.stream().collect(Collectors.groupingBy(ContentRestrictionWorkflowRecord::getSpaceKey, Collectors.groupingBy(ContentRestrictionWorkflowRecord::getContentId, Collectors.groupingBy(ContentRestrictionWorkflowRecord::getTitle, Collectors.groupingBy(content -> Optional.ofNullable(content.getState()))))));
        groupByContent.forEach((spaceKey, contents) -> contents.forEach((contentId, titles) -> titles.forEach((titleKey, states) -> states.forEach((stateName, restrictions) -> {
            HashSet<String> viewUsers = new HashSet<String>();
            HashSet<String> viewGroups = new HashSet<String>();
            HashSet<String> editUsers = new HashSet<String>();
            HashSet<String> editGroups = new HashSet<String>();
            boolean inheritedRestrictions = false;
            for (ContentRestrictionWorkflowRecord restriction : restrictions) {
                inheritedRestrictions = restriction.isInheritedRestrictions();
                if (restriction.getPermissionType() == null) continue;
                switch (restriction.getPermissionType()) {
                    case "View": {
                        if (restriction.getUsername() != null) {
                            viewUsers.add(restriction.getUsername());
                        }
                        if (restriction.getGroupName() == null) break;
                        viewGroups.add(restriction.getGroupName());
                        break;
                    }
                    case "Edit": {
                        if (restriction.getUsername() != null) {
                            editUsers.add(restriction.getUsername());
                        }
                        if (restriction.getGroupName() == null) break;
                        editGroups.add(restriction.getGroupName());
                        break;
                    }
                }
            }
            csvFileContent.addRow(Arrays.asList(contentId.toString(), spaceKey, titleKey, stateName.isPresent() ? (String)stateName.get() : "", String.join((CharSequence)", ", editGroups), String.join((CharSequence)", ", editUsers), String.join((CharSequence)", ", viewGroups), String.join((CharSequence)", ", viewUsers), String.valueOf(inheritedRestrictions)));
        }))));
        return csvFileContent;
    }

    private CsvFileContent generateActivityCSVContent(CsvFileContent csvFileContent, List<ContentActivityCSVWorkflowRecord> records) {
        records.stream().forEach(record -> csvFileContent.addRow(Arrays.asList(record.getSpaceName(), record.getSpaceKey(), record.getStatus().getValue())));
        return csvFileContent;
    }

    private CsvFileContent generateRestrictionsCSVFile(List<ContentRestrictionWorkflowRecord> records) {
        CsvFileContent csvFile = this.generateCSVHeaders(RESTRICTIONS_CHECK, 9);
        csvFile = this.generateRestrictionsCSVContent(csvFile, records);
        return csvFile;
    }

    private CsvFileContent generateActivityCSVFile(List<ContentActivityCSVWorkflowRecord> records) {
        CsvFileContent csvFile = this.generateCSVHeaders(ATTACH_CSV_CHECK, 3);
        csvFile = this.generateActivityCSVContent(csvFile, records);
        return csvFile;
    }
}

