/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.infrastructure;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.ActionDetail;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.ActionType;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.Actor;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.Target;
import com.comalatech.confluence.cloud.migration.usecases.contracts.Presenter;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationTargetMixin;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jackonMixins.ActionDetailMixing;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jackonMixins.ActionTypeMixing;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jackonMixins.MigrationActivityMixin;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jackonMixins.MigrationActorMixin;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="jsonPresenter")
public class JsonPresenter
implements Presenter<String> {
    private static final Logger log = LoggerFactory.getLogger(JsonPresenter.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonPresenter() {
        this.mapper.getSerializationConfig().addMixInAnnotations(Actor.class, MigrationActorMixin.class);
        this.mapper.getSerializationConfig().addMixInAnnotations(Activity.class, MigrationActivityMixin.class);
        this.mapper.getSerializationConfig().addMixInAnnotations(Target.class, MigrationTargetMixin.class);
        this.mapper.getSerializationConfig().addMixInAnnotations(ActionDetail.Type.class, ActionDetailMixing.class);
        this.mapper.getSerializationConfig().addMixInAnnotations(ActionType.Type.class, ActionTypeMixing.class);
        this.mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    @Override
    public <U> String present(List<U> elements) {
        String result;
        try {
            result = this.mapper.writeValueAsString(elements);
            if (result.equalsIgnoreCase("null")) {
                result = "{}";
            }
        }
        catch (Exception e) {
            log.error("Error serializing data {}", elements, (Object)e);
            result = "{}";
        }
        return result;
    }

    @Override
    public <U> String present(U element) {
        String result;
        try {
            result = this.mapper.writeValueAsString(element);
            if (result.equalsIgnoreCase("null")) {
                result = "{}";
            }
        }
        catch (Exception e) {
            log.error("Error serializing data {}", element, (Object)e);
            result = "{}";
        }
        return result;
    }
}

