/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.infrastructure;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.ActionDetail;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.ActionType;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.Actor;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.Target;
import com.comalatech.confluence.cloud.migration.usecases.contracts.Presenter;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationTargetMixin;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jackonMixins.ActionDetailMixing;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jackonMixins.ActionTypeMixing;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jackonMixins.MigrationActivityMixin;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jackonMixins.MigrationActorMixin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="fileJsonPresenter")
public class FileJsonPresenter
implements Presenter<File> {
    private static final Logger log = LoggerFactory.getLogger(FileJsonPresenter.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public FileJsonPresenter() {
        this.mapper.getSerializationConfig().addMixInAnnotations(Actor.class, MigrationActorMixin.class);
        this.mapper.getSerializationConfig().addMixInAnnotations(Activity.class, MigrationActivityMixin.class);
        this.mapper.getSerializationConfig().addMixInAnnotations(Target.class, MigrationTargetMixin.class);
        this.mapper.getSerializationConfig().addMixInAnnotations(ActionDetail.Type.class, ActionDetailMixing.class);
        this.mapper.getSerializationConfig().addMixInAnnotations(ActionType.Type.class, ActionTypeMixing.class);
        this.mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    @Override
    public <U> File present(List<U> elements) {
        File file;
        File result = File.createTempFile("migration", "activities");
        FileOutputStream file2 = new FileOutputStream(result);
        try {
            this.mapper.writeValue((OutputStream)file2, elements);
            file = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)file2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error serializing data {}", elements, (Object)e);
                return null;
            }
        }
        ((OutputStream)file2).close();
        return file;
    }

    @Override
    public <U> File present(U element) {
        File file;
        File result = File.createTempFile("migration", "activities");
        FileOutputStream file2 = new FileOutputStream(result);
        try {
            this.mapper.writeValue((OutputStream)file2, element);
            file = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)file2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error serializing data {}", element, (Object)e);
                return null;
            }
        }
        ((OutputStream)file2).close();
        return file;
    }
}

