/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.actions;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.atlassian.xwork.XsrfTokenGenerator;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskRecord;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskStatus;
import com.comalatech.confluence.cloud.migration.service.DefaultCloudMigrationContentService;
import com.comalatech.confluence.cloud.migration.tasks.AttachActivityTask;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachActivityAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final Logger log = LoggerFactory.getLogger(AttachActivityAction.class);
    private DefaultCloudMigrationContentService defaultCloudMigrationContentService;
    @ComponentImport
    private LongRunningTaskManager longRunningTaskManager;
    private AttachActivityTaskRecord record;
    @ComponentImport
    private XsrfTokenGenerator xsrfTokenGenerator;
    private ServletActionContextCompatManager servletActionContextCompatManager;
    private ReadWriteTransactionService readWriteTransactionService;
    private ComalaI18nBean comalaI18nBean;
    @ComponentImport
    private SettingsManager settingsManager;

    public String view() {
        this.record = this.defaultCloudMigrationContentService.getStatus(this.getSpaceKey());
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String createAttachActivity() {
        this.record = this.defaultCloudMigrationContentService.getStatus(this.getSpaceKey());
        if (!AttachActivityTaskStatus.IN_PROGRESS.equals((Object)this.record.getStatus())) {
            List<Long> pagesWithWorkflow = this.defaultCloudMigrationContentService.getPagesWithWorkflow(this.space.getId());
            AttachActivityTask attachCSVTask = new AttachActivityTask(this.getSpace(), this.record, this.defaultCloudMigrationContentService, this.readWriteTransactionService, this.comalaI18nBean, pagesWithWorkflow);
            LongRunningTaskId longRunningTaskId = this.longRunningTaskManager.startLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), (LongRunningTask)attachCSVTask);
            if (longRunningTaskId != null) {
                this.record.setLongRunningTaskId(longRunningTaskId.toString());
            } else {
                log.debug("Space CSV attachment task did not start, no long running task id was identified for the space:" + this.space.getKey());
            }
        }
        return "success";
    }

    private boolean isConfluenceAdministrator() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isPermitted() {
        return super.isPermitted() && (this.isConfluenceAdministrator() || this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.getSpace()));
    }

    public String getTaskId() {
        return this.record.getLongRunningTaskId() != null ? this.record.getLongRunningTaskId() : null;
    }

    public boolean getIsNotRunStatus() {
        return AttachActivityTaskStatus.NOT_RUN.equals((Object)this.record.getStatus());
    }

    public boolean getIsInProgressStatus() {
        return AttachActivityTaskStatus.IN_PROGRESS.equals((Object)this.record.getStatus());
    }

    public boolean getIsInFailStatus() {
        return AttachActivityTaskStatus.FAIL.equals((Object)this.record.getStatus());
    }

    public Date getStartDate() {
        if (this.record == null || this.record.getStartedTimestamp() == null) {
            return null;
        }
        return new Date(this.record.getStartedTimestamp());
    }

    public String getDuration() {
        if (this.record == null || this.record.getStartedTimestamp() == null || this.record.getEndedTimestamp() == null) {
            return null;
        }
        return (this.record.getEndedTimestamp() - this.record.getStartedTimestamp()) / 1000L + "";
    }

    public String getJobLink() {
        return this.settingsManager.getGlobalSettings().getBaseUrl() + "/longrunningtask.action?taskId=" + this.getTaskId() + "&atl_token=" + this.getAtlToken();
    }

    private String getAtlToken() {
        return this.xsrfTokenGenerator.generateToken(this.servletActionContextCompatManager.getRequest());
    }

    public void setDefaultCloudMigrationContentService(DefaultCloudMigrationContentService defaultCloudMigrationContentService) {
        this.defaultCloudMigrationContentService = defaultCloudMigrationContentService;
    }

    public void setLongRunningTaskManager(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public void setXsrfTokenGenerator(XsrfTokenGenerator xsrfTokenGenerator) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    public void setServletActionContextCompatManager(ServletActionContextCompatManager servletActionContextCompatManager) {
        this.servletActionContextCompatManager = servletActionContextCompatManager;
    }

    public void setReadWriteTransactionService(ReadWriteTransactionService readWriteTransactionService) {
        this.readWriteTransactionService = readWriteTransactionService;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setComalaI18nBean(ComalaI18nBean comalaI18nBean) {
        this.comalaI18nBean = comalaI18nBean;
    }
}

