/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.accessor.events;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.core.util.PairType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.accessor.DefaultCloudMigrationAccessor;
import com.comalatech.confluence.cloud.migration.accessor.events.MigrationAnalyticsEventAccessor;
import com.comalatech.confluence.cloud.migration.entity.events.AnalyticsEventRecord;
import com.comalatech.confluence.util.db.DataBaseNameUtil;
import com.comalatech.confluence.util.db.SqlQueryBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.persistence.Query;
import org.springframework.stereotype.Component;

@Component
public class DefaultMigrationAnalyticsEventAccessor
extends DefaultCloudMigrationAccessor
implements MigrationAnalyticsEventAccessor {
    public DefaultMigrationAnalyticsEventAccessor(@ComponentImport EntityManagerProvider entityManagerProvider) {
        super(entityManagerProvider);
    }

    @Override
    public AnalyticsEventRecord getLatestMigEventByEventType(String eventType) {
        if (this.isEntityAvailable("MIG_ANALYTICS_EVENT")) {
            return this.fetchMigrationAnalyticsEvents(eventType);
        }
        return null;
    }

    private AnalyticsEventRecord fetchMigrationAnalyticsEvents(String eventType) {
        AnalyticsEventRecord analyticsEventRecord = null;
        String databaseEngine = DataBaseNameUtil.getDatabaseName(this.entityManagerProvider);
        SqlQueryBuilder sqlQueryBuilder = new SqlQueryBuilder.Builder(databaseEngine, UnaryOperator.identity()).addTable("MIG_ANALYTICS_EVENT").addField("eventTimestamp").withFilter(new PairType((Serializable)((Object)"eventType"), (Serializable)((Object)eventType))).addLimit(1).addOrder("eventTimestamp").addSort("DESC").build();
        String selectQuery = sqlQueryBuilder.selectQuery();
        Query query = this.entityManagerProvider.getEntityManager().createNativeQuery(selectQuery);
        List result = query.getResultList();
        if (result != null && !result.isEmpty()) {
            analyticsEventRecord = new AnalyticsEventRecord(((Number)result.get(0)).longValue(), eventType);
        }
        return analyticsEventRecord;
    }
}

