/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.accessor.assessment;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.core.util.PairType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.accessor.DefaultCloudMigrationAccessor;
import com.comalatech.confluence.cloud.migration.accessor.assessment.MigrationAppAssessmentAccessor;
import com.comalatech.confluence.cloud.migration.entity.assessment.AppAssessmentRecord;
import com.comalatech.confluence.util.db.DataBaseNameUtil;
import com.comalatech.confluence.util.db.SqlQueryBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.persistence.Query;
import org.springframework.stereotype.Component;

@Component
public class DefaultMigrationAppAssessmentAccessor
extends DefaultCloudMigrationAccessor
implements MigrationAppAssessmentAccessor {
    public DefaultMigrationAppAssessmentAccessor(@ComponentImport EntityManagerProvider entityManagerProvider) {
        super(entityManagerProvider);
    }

    @Override
    public AppAssessmentRecord getAppAssessment(String appKey) {
        if (this.isEntityAvailable("MIG_APP_ASSESSMENT_INFO")) {
            return this.fetchAppAssessmentRecord(appKey);
        }
        return null;
    }

    private AppAssessmentRecord fetchAppAssessmentRecord(String appKey) {
        AppAssessmentRecord appAssessmentRecord = null;
        SqlQueryBuilder sqlQueryBuilder = new SqlQueryBuilder.Builder(DataBaseNameUtil.getDatabaseName(this.entityManagerProvider), UnaryOperator.identity()).addTable("MIG_APP_ASSESSMENT_INFO").addField("assessmentstatus").withFilter(new PairType((Serializable)((Object)"appkey"), (Serializable)((Object)appKey))).build();
        String selectQuery = sqlQueryBuilder.selectQuery();
        Query query = this.entityManagerProvider.getEntityManager().createNativeQuery(selectQuery);
        List result = query.getResultList();
        if (result != null && !result.isEmpty()) {
            appAssessmentRecord = new AppAssessmentRecord(appKey, (String)result.get(0));
        }
        return appAssessmentRecord;
    }
}

