/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.accessor;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskRecord;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskStatus;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AttachActivityAccessor {
    private static final Logger log = LoggerFactory.getLogger(AttachActivityAccessor.class);
    private static final String ATTACH_CSV_KEY = "com.comalatech.workflows.attach.csv";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final BandanaManager bandanaManager;

    public AttachActivityAccessor(@ComponentImport BandanaManager bandanaManager) {
        this.objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.bandanaManager = bandanaManager;
    }

    public AttachActivityTaskRecord getStatus(String spaceKey) {
        String val = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), ATTACH_CSV_KEY);
        if (val != null && !val.isEmpty()) {
            try {
                return (AttachActivityTaskRecord)this.objectMapper.readValue(val, AttachActivityTaskRecord.class);
            }
            catch (IOException e) {
                log.error("Error deserialising AttachActivityTaskRecord", (Throwable)e);
            }
        }
        AttachActivityTaskRecord record = new AttachActivityTaskRecord();
        record.setStatus(AttachActivityTaskStatus.NOT_RUN);
        return record;
    }

    public void setStatus(String spaceKey, AttachActivityTaskRecord status) {
        try {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), ATTACH_CSV_KEY, (Object)this.objectMapper.writeValueAsString((Object)status));
        }
        catch (IOException e) {
            log.error("Error serialising AttachActivityTaskRecord", (Throwable)e);
        }
    }
}

