/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoctasks.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoctasks.TaskPermissionException;
import com.comalatech.confluence.adhoctasks.rest.model.Task;
import com.comalatech.confluence.adhoctasks.rest.model.TaskRequest;
import com.comalatech.confluence.adhoctasks.rest.model.Tasks;
import com.comalatech.confluence.adhocworkflows.rest.AbstractAdhocResources;
import com.comalatech.confluence.adhocworkflows.rest.AbstractRestResources;
import com.comalatech.confluence.adhocworkflows.rest.model.Users;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewWorkflowPermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.util.FancyDateFormatter;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.TaskService;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.model.Assignment;
import com.comalatech.workflow.model.ContentTask;
import com.comalatech.workflow.model.PageStatus;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WorkflowsAppRequired
@Path(value="/tasks")
public class TaskResources
extends AbstractAdhocResources {
    private static final Logger log = LoggerFactory.getLogger(TaskResources.class);
    protected final TaskService taskService;
    protected final UserAccessor userAccessor;

    public TaskResources(@ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport SpacePermissionManager spacePermissionManager, @ComponentImport AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, @ComponentImport BootstrapManager bootstrapManager, TaskService taskService, @ComponentImport UserAccessor userAccessor, ComalaI18nBean comalaI18nBean) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, workflowHandler, userSearchManager, bootstrapManager, comalaI18nBean);
        this.taskService = taskService;
        this.userAccessor = userAccessor;
    }

    @ViewWorkflowPermissionRequired
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{pageId}")
    public Response getTasks(@PathParam(value="pageId") long pageId) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) {
                return TaskResources.this.getTasks(page);
            }
        }.execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/count")
    public Response getTasksCount(@PathParam(value="pageId") long pageId) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) {
                return TaskResources.this.getTasksCount(page);
            }
        }.execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/users")
    public Response getInvolvedUsers(@PathParam(value="pageId") long pageId) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) {
                return Response.ok((Object)new Users(TaskResources.this.makeInvolvedUsers(TaskResources.this.workflowHandler.getInvolvedUsers((ContentEntityObject)page)))).build();
            }
        }.execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/create")
    public Response createTask(@PathParam(value="pageId") long pageId, final TaskRequest taskRequest) {
        return new TaskCommand(){

            @Override
            protected Response doInTaskCommand(AbstractPage page) throws WorkflowException {
                for (String taskName : taskRequest.getNames()) {
                    TaskResources.this.taskService.createTask((ContentEntityObject)page, taskName == null ? null : taskName.trim(), taskRequest.getAssignee(), taskRequest.getNote(), TaskResources.this.parseDate(taskRequest.getDueDate()));
                }
                return TaskResources.this.getStatusWithTasks(page);
            }
        }.execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/{taskId}/complete")
    public Response complete(@PathParam(value="pageId") long pageId, final @PathParam(value="taskId") String taskId, final TaskRequest taskRequest) {
        return new TaskCommand(){

            @Override
            protected Response doInTaskCommand(AbstractPage page) throws WorkflowException {
                try {
                    TaskResources.this.taskService.completeTask((ContentEntityObject)page, taskId, taskRequest.getNote());
                    return TaskResources.this.getStatusWithTasks(page);
                }
                catch (TaskPermissionException ex) {
                    log.error("Error completing the task {}: {}", (Object)taskId, (Object)ex.getMessage());
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
            }
        }.execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/{taskId}/assign")
    public Response assign(@PathParam(value="pageId") long pageId, final @PathParam(value="taskId") String taskId, final TaskRequest taskRequest) {
        return new TaskCommand(){

            @Override
            protected Response doInTaskCommand(AbstractPage page) throws WorkflowException {
                TaskResources.this.taskService.assignTask((ContentEntityObject)page, taskId, taskRequest.getAssignee(), taskRequest.getNote(), TaskResources.this.parseDate(taskRequest.getDueDate()));
                return TaskResources.this.getStatusWithTasks(page);
            }
        }.execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/{taskId}/update")
    public Response update(@PathParam(value="pageId") long pageId, final @PathParam(value="taskId") String taskId, final TaskRequest taskRequest) {
        return new TaskCommand(){

            @Override
            protected Response doInTaskCommand(AbstractPage page) throws WorkflowException {
                try {
                    if (taskRequest.getNames() != null && taskRequest.getNames().size() > 0) {
                        TaskResources.this.taskService.editTask((ContentEntityObject)page, taskId, taskRequest.getNames().get(0), taskRequest.getNote(), TaskResources.this.parseDate(taskRequest.getDueDate()));
                    }
                    return TaskResources.this.getStatusWithTasks(page);
                }
                catch (TaskPermissionException ex) {
                    log.error("Error updating the task {}: {}", (Object)taskId, (Object)ex.getMessage());
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
            }
        }.execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/{taskId}/remove")
    public Response remove(@PathParam(value="pageId") long pageId, final @PathParam(value="taskId") String taskId, final TaskRequest taskRequest) {
        return new TaskCommand(){

            @Override
            protected Response doInTaskCommand(AbstractPage page) throws WorkflowException {
                try {
                    TaskResources.this.taskService.removeTask((ContentEntityObject)page, taskId, taskRequest != null ? taskRequest.getNote() : "");
                    return TaskResources.this.getStatusWithTasks(page);
                }
                catch (TaskPermissionException ex) {
                    log.error("Error deleting the task {}: {}", (Object)taskId, (Object)ex.getMessage());
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
            }
        }.execute(pageId);
    }

    private Response getStatusWithTasks(AbstractPage page) {
        PageStatus pageStatus = this.workflowHandler.getPageStatus((ContentEntityObject)page, false, true);
        if (pageStatus != null) {
            pageStatus.setTasks(this.getTaskList(page));
            return Response.ok((Object)pageStatus).build();
        }
        return Response.noContent().build();
    }

    protected List<Task> getTaskList(AbstractPage page) {
        List<ContentTask> contentTasks = this.taskService.getTasks((ContentEntityObject)page);
        ArrayList<Task> tasks = new ArrayList<Task>(contentTasks.size());
        for (ContentTask contentTask : contentTasks) {
            tasks.add(this.makeTask(contentTask));
        }
        return tasks;
    }

    private Response getTasks(AbstractPage page) {
        Tasks tasksObject = new Tasks();
        tasksObject.setTasks(this.getTaskList(page));
        return Response.ok((Object)tasksObject).build();
    }

    private Response getTasksCount(AbstractPage page) {
        return Response.ok((Object)this.taskService.getTasks((ContentEntityObject)page).size()).build();
    }

    private Task makeTask(ContentTask contentTask) {
        Assignment lastAssignment;
        String assignee = null;
        if (contentTask.getTask().getLastAssignment() != null && StringUtils.isNotBlank((CharSequence)(lastAssignment = contentTask.getTask().getLastAssignment()).getAssignee())) {
            assignee = lastAssignment.getAssignee();
        }
        Task task = new Task(contentTask.getTask().getActivityId(), contentTask.getTask().getName(), this.userSearchManager.makeUser(assignee), contentTask.getTask().isCompleted());
        this.setTaskCaption(contentTask, task);
        if (task.isCompleted()) {
            task.addAction(Task.Action.VIEW);
        } else if (contentTask.getTask().canComplete()) {
            task.addAction(Task.Action.COMPLETE);
        }
        task.setHint(this.getAssignedBlurb(assignee));
        task.addAction(Task.Action.ASSIGN);
        if (this.canAdminWorkflow((AbstractPage)contentTask.getContent(), (User)AuthenticatedUserThreadLocal.get()) || contentTask.getTask().getPerformer().equals(AuthenticatedUserThreadLocal.getUsername())) {
            task.addAction(Task.Action.REMOVE);
        }
        if (contentTask.getTask().getDueDate() != null) {
            task.setDueDate(this.formatDate(contentTask.getTask().getDueDate()));
            FancyDateFormatter.decorateDateTimePretty(contentTask.getTask().getDueDate(), false);
            task.setFriendlyDueDate(FancyDateFormatter.decorateDateTimePretty(contentTask.getTask().getDueDate(), false));
        }
        return task;
    }

    private void setTaskCaption(ContentTask contentTask, Task task) {
        String actionKey;
        String actorName;
        String date;
        com.comalatech.workflow.model.Task daTask = contentTask.getTask();
        if (daTask.isCompleted()) {
            date = FancyDateFormatter.decorateDateTimePretty(daTask.getLastCompletion().getDate(), false);
            actorName = daTask.getLastCompletion().getPerformer();
            actionKey = "com.comalatech.activity.report.task.completed-by";
        } else {
            Assignment lastAssignment = daTask.getLastAssignment();
            if (lastAssignment != null) {
                date = FancyDateFormatter.decorateDateTimePretty(lastAssignment.getDate(), false);
                actorName = lastAssignment.getPerformer();
                actionKey = "com.comalatech.activity.report.task.assigned-by";
            } else {
                date = FancyDateFormatter.decorateDateTimePretty(daTask.getDate(), false);
                actorName = daTask.getPerformer();
                actionKey = "com.comalatech.activity.report.task.created-by";
            }
        }
        task.setDate(date);
        task.setActor(this.userSearchManager.makeUser(actorName));
        task.setLastAction(this.comalaI18nBean.getText(actionKey));
        task.setComment(daTask.getComment());
    }

    private String getAssignedBlurb(String assignee) {
        if (!StringUtils.isNotBlank((CharSequence)assignee)) {
            return "";
        }
        ConfluenceUser user = this.userAccessor.getUserByName(assignee);
        if (user == null) {
            return "";
        }
        return this.comalaI18nBean.getText("comalatech.awp.states.report.assigned-to.label.caption", new String[]{user.getFullName()});
    }

    public abstract class TaskCommand
    extends AbstractRestResources.WorkflowCommand {
        public TaskCommand() {
            super(TaskResources.this);
        }

        protected abstract Response doInTaskCommand(AbstractPage var1) throws WorkflowException;

        @Override
        protected Response doInCommand(AbstractPage page) {
            try {
                return this.doInTaskCommand(page);
            }
            catch (WorkflowException e) {
                if (log.isDebugEnabled()) {
                    log.error("", (Throwable)e);
                } else {
                    log.error(e.getMessage());
                }
                return TaskResources.this.getTasks(page);
            }
        }
    }
}

