/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoctasks.actions.conditions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;

public class IsWorkflowTaskableCondition
extends BaseConfluenceCondition {
    private final StateService stateService;
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final WorkflowPermissionManager workflowPermissionManager;

    public IsWorkflowTaskableCondition(StateService stateService, AdhocWorkflowManager adhocWorkflowManager, WorkflowPermissionManager workflowPermissionManager) {
        this.stateService = stateService;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.workflowPermissionManager = workflowPermissionManager;
    }

    protected boolean shouldDisplay(WebInterfaceContext context) {
        State state;
        AbstractPage page = context.getPage();
        if (page == null || context.getCurrentUser() == null) {
            return false;
        }
        if (!this.workflowPermissionManager.canViewDrafts(page, AuthenticatedUserThreadLocal.get())) {
            return false;
        }
        return this.stateService == null || (state = this.stateService.getCurrentState((ContentEntityObject)page)) != null || this.adhocWorkflowManager.isAdhocWorkflowAllowed(page);
    }
}

