/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.keys.UpgradePropertiesKeys;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(UpgradeManager.class);
    private static final String CURRENT_INSTALLED_BUILD_KEY = "com.comalatech.awp.currentbuild";
    private static final String PREVIOUS_INSTALL_KEY_PREFIX = "com.comalatech.awp.installhistory.";
    private static final int NO_VERSION = -1;
    private final BandanaManager bandanaManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;

    public UpgradeManager(@ComponentImport BandanaManager bandanaManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowsFeatureManager workflowsFeatureManager) {
        this.bandanaManager = bandanaManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        int previousBuildNumber = this.getCurrentBuildNumber();
        this.checkApplicationInstallationStatus(previousBuildNumber);
        if (previousBuildNumber != workflowConfigurationManager.getPluginVersionNumber()) {
            this.setCurrentBuildNumber(workflowConfigurationManager.getPluginVersionNumber());
            this.setInstallHistory(workflowConfigurationManager.getPluginVersionNumber());
            log.info("Comala Documents Management updated to build: " + workflowConfigurationManager.getPluginVersionNumber());
        }
    }

    private void checkApplicationInstallationStatus(int previousBuildNumber) {
        Object currentAppVersion = this.bandanaManager.getValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, this.getPluginSettingKey(UpgradePropertiesKeys.APPLICATION_CURRENT_VERSION));
        if (currentAppVersion != null) {
            this.bandanaManager.setValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, this.getPluginSettingKey(UpgradePropertiesKeys.NEW_INSTALL_KEY), (Object)"false");
        } else if (previousBuildNumber != -1) {
            this.bandanaManager.setValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, this.getPluginSettingKey(UpgradePropertiesKeys.NEW_INSTALL_KEY), (Object)"false");
        } else {
            this.bandanaManager.setValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, this.getPluginSettingKey(UpgradePropertiesKeys.NEW_INSTALL_KEY), (Object)"true");
        }
    }

    protected void setCurrentBuildNumber(int buildNumber) {
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, CURRENT_INSTALLED_BUILD_KEY, (Object)(buildNumber + ""));
        this.bandanaManager.setValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, this.getPluginSettingKey(UpgradePropertiesKeys.APPLICATION_CURRENT_VERSION), (Object)(buildNumber + ""));
    }

    protected int getCurrentBuildNumber() {
        Object obj = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, CURRENT_INSTALLED_BUILD_KEY);
        if (obj != null) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (NumberFormatException nfe) {
                log.error("Error parsing saved canvas build number", (Throwable)nfe);
            }
        }
        return -1;
    }

    protected void setInstallHistory(int buildNumber) {
        Object obj = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, PREVIOUS_INSTALL_KEY_PREFIX + buildNumber);
        if (obj == null) {
            this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, PREVIOUS_INSTALL_KEY_PREFIX + buildNumber, (Object)(new Date().getTime() + ""));
        }
    }

    private String getPluginSettingKey(UpgradePropertiesKeys key) {
        return this.workflowsFeatureManager.getPluginKey() + (Object)((Object)UpgradePropertiesKeys.KEY_SEPARATOR) + key.toString();
    }
}

