/*
 * Copyright (c) 2024 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    CW.toInit(function () {
        $('.cw-workflow-approval-report-container[data-cw-report]').each(function (i, item) {
            const $target = $(item);
            const pageId = $target.data('cwPageId') || CW.getParam('pageId');
            const spaceKey = $target.data('cwSpaceKey');
            const numberOfItemsPerPage = $target.data('cwNumberOfItems');
            const filterWorkflows = $target.data('cwWorkflowFilterOptions');
            const filterStates = $target.data('cwStateFilterOptions');
            const columnsToShow = $target.data('cwColumnsToShow');
            const cqlQuery = $target.data('cwCql');
            const preSelectedStates = $target.data('cwPreSelectedStates');
            const preSelectedWorkflows = $target.data('cwPreSelectedWorkflows');
            const approvalName = $target.data('cwApprovalName');
            const approvalStatus = $target.data('cwApprovalStatus');
            const assignee = $target.data('cwAssignee');
            // Workflow States Report Macro Iframe
            const WorkflowApprovalReportIframe = new CW.iframe({
                id: 'WorkflowApprovalsReportIframe-' + pageId + '-' + i,
                url: '/report/approvals/' + spaceKey,
                width: '100%',
                height: '100%',
                query: {
                    rowsPerPage: numberOfItemsPerPage,
                    columnsToShow: columnsToShow,
                },
                customData: {
                    spaceKey: spaceKey,
                    filterNumberOfItems: numberOfItemsPerPage,
                    filterWorkflows: filterWorkflows,
                    filterStates: filterStates,
                    cqlQuery: cqlQuery,
                    preSelectedStates: preSelectedStates,
                    preSelectedWorkflows: preSelectedWorkflows,
                    approvalName: approvalName,
                    approvalStatus: approvalStatus,
                    assignee: assignee,
                    dateFormat: CW.getParam('cwConfluenceDateFormat'),
                    timeFormat: CW.getParam('cwConfluenceTimeFormat'),
                    dateTimeFormat: CW.getParam('cwConfluenceDateTimeFormat'),
                    locale: CW.getParam('cwConfluenceLocale')
                }
            });

            /** If the Iframe is inside an expand Macro we need to reload the iframe */
            AJS.$('.expand-control').click((e) => {
                const expandItem = e.currentTarget.id.replace('control', 'content');
                const iframe = $(`#${expandItem}`).find(`#WorkflowApprovalsReportIframe-${pageId}-${i}`);
                if (iframe.length !== 0) {
                    $target.html(WorkflowApprovalReportIframe.reload());
                }
            });

            $target.html(WorkflowApprovalReportIframe.render());
        })
    });
});
