/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.support;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Map;
import org.randombits.confluence.support.PageInfo;
import org.randombits.storage.IndexedStorage;
import org.randombits.storage.confluence.MacroParameterStorage;
import org.randombits.storage.param.ParameterParser;
import org.randombits.storage.param.ParameterParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroInfo
extends PageInfo {
    private static ParameterParser RAW_PARAM_PARSER = new ParameterParser('=', '|', '\\');
    private String body;
    private IndexedStorage macroParams;

    public MacroInfo(Map<String, String> params, String body, PageContext pageCtx) throws MacroException {
        this(params, body, pageCtx, true);
    }

    public MacroInfo(Map<String, String> params, String body, PageContext pageCtx, boolean escaped) throws MacroException {
        this(MacroInfo.createParameterStorage(params, escaped), body, pageCtx);
    }

    public MacroInfo(IndexedStorage params, String body, PageContext pageCtx) {
        this.macroParams = params;
        this.body = body;
        this.pageCtx = pageCtx;
        this.content = pageCtx.getEntity();
    }

    public MacroInfo(IndexedStorage macroParams, String body, MacroInfo info) {
        this(macroParams, body, info.getPageContext());
    }

    public MacroInfo(MacroInfo info) {
        this(info.macroParams, info.body, info.pageCtx);
    }

    public static IndexedStorage createParameterStorage(Map<String, String> params, boolean escaped) throws MacroException {
        String raw;
        if (escaped && (raw = params.get(": = | RAW | = :")) != null) {
            try {
                return RAW_PARAM_PARSER.parseList(raw, false);
            }
            catch (ParameterParsingException e) {
                throw new MacroException(e.getMessage(), (Throwable)e);
            }
        }
        return new MacroParameterStorage(params);
    }

    public String getMacroBody() {
        return this.body;
    }

    public IndexedStorage getMacroParams() {
        return this.macroParams;
    }
}

