/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.model;

import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public enum StateReportParameters {
    SPACE("space", "@self"),
    ITEMS_PER_PAGE("maxItems", "20"),
    COLUMNS_TO_SHOW("columns", "title,state,changed,updated by,updated"),
    SORT("sort", "title"),
    SORT_ORDER("sortOrder", "descending"),
    PARENT_PAGE("parent"),
    LABEL("label"),
    STATE("state"),
    WORKFLOW("workflow"),
    CQL_FILTER("cqlFilter");

    private final String key;
    private String defaultValue;

    private StateReportParameters(String key) {
        this.key = key;
    }

    private StateReportParameters(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public static Optional<StateReportParameters> fromString(String text) {
        return Arrays.stream(StateReportParameters.values()).filter(reportFilter -> reportFilter.key.equalsIgnoreCase(text)).findFirst();
    }

    public static List<ReportParameter> getFiltersFrom(Set<Map.Entry> macroParameterSet) {
        ArrayList<ReportParameter> stateReportFilters = new ArrayList<ReportParameter>();
        for (Map.Entry macroParam : macroParameterSet) {
            Optional<StateReportParameters> filter = StateReportParameters.fromString(macroParam.getKey().toString());
            if (!filter.isPresent()) continue;
            String value = macroParam.getValue() == null ? null : macroParam.getValue().toString().trim();
            stateReportFilters.add(new ReportParameter(filter.get().key, new StringReportParameterValue(value, filter.get().defaultValue)));
        }
        StateReportParameters.addMandatoryParameters(stateReportFilters);
        return stateReportFilters;
    }

    private static void addMandatoryParameters(List<ReportParameter> stateReportFilters) {
        boolean existOrder;
        boolean existSort;
        boolean existColumns;
        boolean existItemsPerPage;
        boolean existSpaceParam = stateReportFilters.stream().anyMatch(param -> param.getKey().equals(SPACE.getKey()));
        if (!existSpaceParam) {
            stateReportFilters.add(new ReportParameter(StateReportParameters.SPACE.key, new StringReportParameterValue(null, StateReportParameters.SPACE.defaultValue)));
        }
        if (!(existItemsPerPage = stateReportFilters.stream().anyMatch(param -> param.getKey().equals(ITEMS_PER_PAGE.getKey())))) {
            stateReportFilters.add(new ReportParameter(StateReportParameters.ITEMS_PER_PAGE.key, new StringReportParameterValue(null, StateReportParameters.ITEMS_PER_PAGE.defaultValue)));
        }
        if (!(existColumns = stateReportFilters.stream().anyMatch(param -> param.getKey().equals(COLUMNS_TO_SHOW.getKey())))) {
            stateReportFilters.add(new ReportParameter(StateReportParameters.COLUMNS_TO_SHOW.key, new StringReportParameterValue(null, StateReportParameters.COLUMNS_TO_SHOW.defaultValue)));
        }
        if (!(existSort = stateReportFilters.stream().anyMatch(param -> param.getKey().equals(SORT.getKey())))) {
            stateReportFilters.add(new ReportParameter(StateReportParameters.SORT.key, new StringReportParameterValue(null, StateReportParameters.SORT.defaultValue)));
        }
        if (!(existOrder = stateReportFilters.stream().anyMatch(param -> param.getKey().equals(SORT_ORDER.getKey())))) {
            stateReportFilters.add(new ReportParameter(StateReportParameters.SORT_ORDER.key, new StringReportParameterValue(null, StateReportParameters.SORT_ORDER.defaultValue)));
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getKey() {
        return this.key;
    }
}

