/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rules.permission;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.workflow.permissions.DefaultWorkflowPermissionManager;
import com.comalatech.confluence.workflow.rules.permission.PermissionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanAddSpaceWorkflow
implements PermissionRule<Space> {
    private static final Logger log = LoggerFactory.getLogger(CanAddSpaceWorkflow.class);
    private final DefaultWorkflowPermissionManager workflowPermissionManager;

    public CanAddSpaceWorkflow(DefaultWorkflowPermissionManager workflowPermissionManager) {
        this.workflowPermissionManager = workflowPermissionManager;
    }

    @Override
    public boolean validate(Space space, boolean extraCheck) {
        try {
            if (space == null) {
                throw new IllegalArgumentException("Space is null");
            }
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            if (!this.workflowPermissionManager.canAddSpaceWorkflows(space, user)) {
                throw new IllegalArgumentException("Workflows are not allowed or the user doesn't have permission in the space " + space.getKey() + "!");
            }
            return true;
        }
        catch (IllegalArgumentException ex) {
            log.debug("Error validation Can Have Space Workflow VerificationRule! : {0}", (Throwable)ex);
            return false;
        }
    }
}

