/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.resources;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.ipc.api.DefaultWorkflowTemplateManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.rest.model.RestRemoteWorkflowsRepository;
import com.comalatech.confluence.workflow.restv2.accessor.MarkupValidationException;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflow;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import com.comalatech.confluence.workflow.restv2.resources.AbstractRestResource;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Qualifier;

@WorkflowsAppRequired
@Path(value="/admin/workflows")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PermissionRequired(value={"ADMINISTER"})
public class WorkflowAdminResource
extends AbstractRestResource {
    private final WorkflowService workflowService;
    private final WorkflowTemplateManager workflowTemplateManager;
    private final WorkflowContainerManager workflowContainerManager;

    public WorkflowAdminResource(PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager, WorkflowService workflowService, @Qualifier(value="workflowTemplateManager") WorkflowTemplateManager workflowTemplateManager, WorkflowContainerManager workflowContainerManager, ComalaI18nBean comalaI18nBean) {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager, comalaI18nBean);
        this.workflowService = workflowService;
        this.workflowTemplateManager = workflowTemplateManager;
        this.workflowContainerManager = workflowContainerManager;
    }

    @GET
    @Path(value="/{workflowId}")
    public Response getGlobalWorkflow(final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                List<com.comalatech.workflow.model.Workflow> globalWorkflows = ((DefaultWorkflowTemplateManager)WorkflowAdminResource.this.workflowTemplateManager).getAllWorkflowTemplates();
                if (globalWorkflows == null) {
                    return Response.noContent().build();
                }
                return WorkflowAdminResource.this.getSingleWorkflowResponse(globalWorkflows, workflowId);
            }
        }.execute();
    }

    @PUT
    @Path(value="/{workflowId}")
    public Response updateWorkflow(final @PathParam(value="workflowId") String workflowId, final RestWorkflow jsonMarkup) {
        return new AbstractRestResource.RestCommand(){

            @Override
            public Response doExecute() throws WorkflowException, MarkupValidationException {
                WorkflowAdminResource.this.workflowMarkupManager.validateJsonMarkup(jsonMarkup);
                Workflow workflow = Mappers.workflowMapper.fromRest(jsonMarkup);
                String name = workflow.getName();
                String description = workflow.getDescription();
                String markup = workflow.toMacro().toString();
                com.comalatech.workflow.model.Workflow updatedWorkflow = WorkflowAdminResource.this.workflowService.updateWorkflow(null, workflowId, name, description, null, markup, true, true, true);
                return Response.ok((Object)Mappers.workflowMapper.toRest((Workflow)updatedWorkflow)).build();
            }
        }.execute();
    }

    @POST
    @Path(value="/")
    public Response createGlobalWorkflow(final RestWorkflow jsonMarkup) {
        return new AbstractRestResource.RestCommand(){

            @Override
            public Response doExecute() throws WorkflowException, MarkupValidationException {
                WorkflowAdminResource.this.workflowMarkupManager.validateJsonMarkup(jsonMarkup);
                Workflow workflow = Mappers.workflowMapper.fromRest(jsonMarkup);
                String markup = workflow.toMacro().toString();
                com.comalatech.workflow.model.Workflow newWorkflow = WorkflowAdminResource.this.workflowService.addGlobalWorkflow(markup);
                return Response.ok((Object)Mappers.workflowMapper.toRest((Workflow)newWorkflow)).build();
            }
        }.execute();
    }

    @PUT
    @Path(value="/restore-backup/{workflowId}")
    public Response restoreWorkflowBackup(final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestCommand(){

            @Override
            public Response doExecute() throws WorkflowException {
                com.comalatech.workflow.model.Workflow updatedWorkflow = WorkflowAdminResource.this.workflowService.restoreWorkflowBackup(null, workflowId);
                return Response.ok((Object)Mappers.workflowMapper.toRest((Workflow)updatedWorkflow)).build();
            }
        }.execute();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/repo")
    public Response loadRepositoryWorkflows(final @QueryParam(value="categoryId") String categoryId, final @QueryParam(value="refresh") String refresh) {
        return new AbstractRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                boolean reload = Boolean.parseBoolean(refresh);
                RestRemoteWorkflowsRepository restRemoteWorkflowsRepository = WorkflowAdminResource.this.workflowContainerManager.getRestRemoteWorkflows(reload, categoryId, null);
                return Response.ok().entity((Object)restRemoteWorkflowsRepository).type("application/json").build();
            }
        }.execute();
    }
}

