/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.parser;

import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateColour;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.ApproverCondition;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.ConditionHandler;
import com.comalatech.confluence.workflow.model.HasApprovalCondition;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.workflow.model.WorkflowParameter;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class WorkflowPreProcessor {
    private final ComalaI18nBean comalaI18nBean;

    public WorkflowPreProcessor(ComalaI18nBean comalaI18nBean) {
        this.comalaI18nBean = comalaI18nBean;
    }

    public void process(Workflow workflow) throws WorkflowException {
        this.doProcess(workflow, workflow.getApprovals());
    }

    public void process(Workflow workflow, List approvals) throws WorkflowException {
        this.doProcess(workflow, approvals);
    }

    private void doProcess(Workflow workflow, List approvals) throws WorkflowException {
        Processor processor = new Processor(approvals);
        processor.process();
        if (workflow != null) {
            this.initStates(workflow);
            this.checkRequiredParams(workflow);
        }
    }

    private void initStates(Workflow workflow) throws WorkflowException {
        StatesContainer statesContainer = workflow.getStatesContainer();
        if (statesContainer == null) {
            return;
        }
        statesContainer.initialize(workflow.isAdhoc());
        workflow.registerStateTransitions();
        boolean workflowHasFinalState = workflow.getStatesContainer().isRequiresFinalApproval();
        for (State state : workflow.getStatesContainer().getStates()) {
            if (state.getSucceedingStates().size() > 0 && state.getApprovals().size() == 0) {
                state.setApprovals(workflow.getApprovals());
            } else {
                Processor processor = new Processor(state.getApprovals(), state.getPreceedingStates());
                processor.process();
            }
            if (state.getColour() == null) {
                state.setColour(workflowHasFinalState ? (state.isFinalState() ? StateColour.GREEN.getValue() : StateColour.YELLOW.getValue()) : StateColour.BLUE.getValue());
                continue;
            }
            String reservedWordsColoursRegex = "[A-Za-z]{1,30}";
            String hexadecimalColoursRegex = "#([\\d[A-Za-z]]{3}){1,2}";
            String rgbaHslaColoursRegex = "(rgb|hsl)a\\((\\d{1,3}%?,\\s?){3}(1|0?\\.\\d+)\\)";
            String rgbHslColoursRegex = "(rgb|hsl)\\(\\d{1,3}%?(,\\s?\\d{1,3}%?){2}\\)";
            String combinedRegex = "[A-Za-z]{1,30}|#([\\d[A-Za-z]]{3}){1,2}|(rgb|hsl)a\\((\\d{1,3}%?,\\s?){3}(1|0?\\.\\d+)\\)|(rgb|hsl)\\(\\d{1,3}%?(,\\s?\\d{1,3}%?){2}\\)";
            Pattern pattern = Pattern.compile("[A-Za-z]{1,30}|#([\\d[A-Za-z]]{3}){1,2}|(rgb|hsl)a\\((\\d{1,3}%?,\\s?){3}(1|0?\\.\\d+)\\)|(rgb|hsl)\\(\\d{1,3}%?(,\\s?\\d{1,3}%?){2}\\)");
            Matcher matcher = pattern.matcher(state.getColour());
            if (matcher.matches()) continue;
            throw new WorkflowException(this.comalaI18nBean.getText("comalatech.awp.parameters.parameters.error.colour", new Object[]{state.getColour()}));
        }
    }

    private void checkRequiredParams(Workflow workflow) throws WorkflowException {
        StatesContainer statesContainer = workflow.getStatesContainer();
        if (statesContainer == null) {
            return;
        }
        List editableWorkflowParameterNames = workflow.getWorkflowParameters().stream().filter(WorkflowParameter::isPageEditable).map(WorkflowParameter::getName).collect(Collectors.toList());
        for (State state : statesContainer.getStates()) {
            for (String requiredParam : StringUtils.defaultString((String)state.getRequiredParams()).split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)requiredParam) || editableWorkflowParameterNames.contains(requiredParam.trim())) continue;
                throw new WorkflowException(String.format("The required parameter %s at the state %s MUST be declared as an editable {workflow-parameter}", requiredParam.trim(), state.getName()));
            }
        }
    }

    public class Processor
    implements ConditionHandler {
        private List approvals;
        private List precedingStates;
        private HashMap approvalsMap = new HashMap();
        private Approval approval;

        public Processor(List approvals) {
            this.approvals = approvals;
            for (Approval approval : approvals) {
                this.approvalsMap.put(approval.getName(), approval);
            }
        }

        public Processor(List approvals, List precedingStates) {
            this(approvals);
            this.precedingStates = precedingStates;
        }

        public void process() throws WorkflowException {
            for (Approval this.approval : this.approvals) {
                this.approval.handleConditions(this);
            }
        }

        @Override
        public void handle(Condition condition) throws WorkflowException {
            if (condition instanceof HasApprovalCondition) {
                HasApprovalCondition hasApprovalCondition = (HasApprovalCondition)condition;
                String[] approvalNames = hasApprovalCondition.getApprovalNames();
                for (int i = 0; i < approvalNames.length; ++i) {
                    String approvalName = approvalNames[i];
                    Approval preceedingApproval = this.getApproval(approvalName);
                    boolean preceedingState = false;
                    if (preceedingApproval == null && this.precedingStates != null) {
                        preceedingApproval = this.getApprovalFromPreceedingStates(approvalName);
                        preceedingState = true;
                    }
                    if (preceedingApproval == null) continue;
                    preceedingApproval.addDependingApproval(this.approval);
                    this.approval.addPreceedingApproval(preceedingApproval);
                    if (!preceedingState) continue;
                    hasApprovalCondition.setCurrent(false);
                }
            } else if (condition instanceof ApproverCondition) {
                ApproverCondition approverCondition = (ApproverCondition)condition;
                Selector selector = approverCondition.getSelector();
                this.updateApproval(selector);
            }
        }

        private void updateApproval(Selector selector) {
            selector.setApprovalName(this.approval.getName());
            if (this.approval.getSelector() != null) {
                selector = this.mergeSelectors(this.approval.getSelector(), selector);
            }
            this.approval.setSelector(selector);
        }

        private Selector mergeSelectors(Selector currentSelector, Selector selector) {
            if (currentSelector.isAllMustApprove() && selector.isAllMustApprove()) {
                String users = currentSelector.getUsers();
                String mergedUsers = users.concat("," + selector.getUsers());
                return new Selector(mergedUsers, 3, currentSelector.getMinimum());
            }
            return currentSelector;
        }

        private Approval getApproval(String approvalName) {
            return (Approval)this.approvalsMap.get(approvalName);
        }

        private Approval getApprovalFromPreceedingStates(String approvalName) {
            for (Object precedingState : this.precedingStates) {
                State state = (State)precedingState;
                for (Approval stateApproval : state.getApprovals()) {
                    if (!stateApproval.getName().equals(approvalName)) continue;
                    return stateApproval;
                }
            }
            return null;
        }
    }
}

