/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.comalatech.workflow.model.WorkflowParameterType;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class WorkflowParameter
extends WorkflowElement
implements com.comalatech.workflow.model.WorkflowParameter,
Macroable {
    String name;
    WorkflowParameterType type;
    String value;
    String description;
    boolean pageEditable;
    List<String> options;
    String optionsList;
    String optionsListReference;

    public WorkflowParameter(String name, String description, WorkflowParameterType type, String value, String options, boolean pageEditable) {
        super(null);
        this.name = name;
        this.type = type;
        this.value = value;
        this.description = description;
        this.pageEditable = pageEditable;
        this.setOptions(options);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WorkflowParameterType getType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setOptions(String options) {
        this.options = Arrays.asList(MiscUtils.splitAndTrim(options));
        String string = this.optionsList = StringUtils.isNotBlank((CharSequence)options) ? options.replaceAll("\\s*,\\s*", ",") : null;
        if (options != null && options.startsWith("@")) {
            this.optionsListReference = options.replaceAll("@", "");
        }
    }

    public String getOptionsList() {
        return this.optionsList;
    }

    public String getOptionsListReference() {
        return this.optionsListReference;
    }

    @Override
    public List<String> getOptions() {
        return this.options;
    }

    public String toString() {
        return "WorkflowParameter{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + (StringUtils.isNotBlank((CharSequence)this.optionsList) ? ", options='" + this.optionsList + "'" : "") + ", defaultValue='" + this.value + '\'' + '}';
    }

    @Override
    public SerializableMacro toMacro() {
        SerializableMacro macro = new SerializableMacro("workflowparameter", true);
        macro.addParameter(this.name);
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            macro.addParameter("description", (Object)this.description);
        }
        if (StringUtils.isNotBlank((CharSequence)this.value)) {
            macro.setBody(this.value);
        } else {
            macro.setBody("");
        }
        if (this.type != WorkflowParameterType.DEFAULT) {
            macro.addParameter("type", (Object)this.type.getName());
        }
        if (this.type == WorkflowParameterType.LIST) {
            macro.addParameter("options", (Object)this.optionsList);
        }
        if (this.pageEditable) {
            macro.addParameter("edit", (Object)this.pageEditable);
        }
        return macro;
    }

    @Override
    public boolean isPageEditable() {
        return this.pageEditable;
    }
}

