/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.dataextractor.queue.AppfireQueueService;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.macros.actions.AbstractMessageMacro;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendEmailMacro
extends AbstractMessageMacro {
    private static final Logger log = LoggerFactory.getLogger(SendEmailMacro.class);
    public static final String PARAM_USER = "user";
    public static final String PARAM_USERS = "users";
    public static final String PARAM_EMAILADDRESS = "address";
    public static final String PARAM_SUBJECT = "subject";
    public static final String PARAM_FOOTER = "footer";
    public static final String[] PARAM_MIMETYPE = new String[]{"mimetype", "type", "mimeType", "mimetyle"};
    public static final String MACRO_NAME = "send-email";
    private GlobalSettingsManager globalSettingsManager;
    private AppfireQueueService appfireQueueService;
    private UserAccessor userAccessor;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private AdhocNotificationService adhocNotificationService;
    private VelocityHelperService velocityHelperService;

    @Override
    protected String getName() {
        return MACRO_NAME;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String usersList = (String)parameters.get(PARAM_USER);
        if (!StringUtils.isNotBlank((CharSequence)usersList)) {
            usersList = (String)parameters.get(PARAM_USERS);
        }
        String subject = (String)parameters.get(PARAM_SUBJECT);
        String address = MapUtils.getString(parameters, PARAM_EMAILADDRESS);
        if (!StringUtils.isNotBlank((CharSequence)usersList) && !StringUtils.isNotBlank((CharSequence)address)) {
            throw new MacroException("need to define at least one user or email address to send to");
        }
        if (!this.inExecuteMode(renderContext)) {
            return "";
        }
        AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
        String mimeTypeParam = this.getParam(parameters, PARAM_MIMETYPE);
        try {
            PageContext pageContext = page.toPageContext();
            ValueStore valueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
            String baseUrl = this.globalSettingsManager.getGlobalSettings().getBaseUrl();
            pageContext.setBaseUrl(baseUrl);
            pageContext.setSiteRoot(baseUrl);
            pageContext.addParam((Object)"valueStore", (Object)valueStore);
            pageContext.addParam((Object)MACRO_NAME, (Object)"true");
            ConfluenceUser[] users = null;
            try {
                users = this.usersListResolver.getValueAsUsers(valueStore, valueStore.getPage(), usersList, true);
            }
            catch (WorkflowUserException wue) {
                log.error("Error getting users for sending Comala Workflows email on page: " + page + ". Error message:[" + wue.getMessage() + "]. Note: {send-email} is limited to a maximum of 500 users, you may need to reconfigure the workflow to reduce the number of users emailed or use the address parameter to send to a group email address. If you use address parameter make sure to enable the Email Any Address option in the global Workflows Configuration page", (Throwable)wue);
                throw new WorkflowUserException(this.comalaI18nBean.getText("com.comalatech.sendemailmacro.usersError") + " Error message:[" + wue.getMessage() + "]");
            }
            subject = StringUtils.isNotBlank((CharSequence)subject) ? valueStore.replaceReferences(subject) : "";
            if (log.isDebugEnabled()) {
                log.debug("send email macro execution, refReplaced subject: " + subject + "    address string: " + address + "    resolvedUserList: " + (users != null ? Arrays.asList(users) : null));
            }
            for (ConfluenceUser user : users) {
                if (this.userAccessor.isDeactivated((User)user)) continue;
                String mimeType = this.getMessageMimeType(mimeTypeParam, user);
                String message = this.getRenderedMessage(mimeType, user, (RenderContext)pageContext, body, MapUtils.getString(parameters, PARAM_FOOTER));
                ConfluenceMailQueueItem queueItem = new ConfluenceMailQueueItem(user.getEmail(), subject, message, mimeType);
                SMTPMailServer mailServer = this.adhocNotificationService.getMailServer();
                if (mailServer == null) {
                    log.warn("Wrong email configuration. The mail server was not found");
                }
                queueItem.setFromAddress(mailServer != null ? mailServer.getDefaultFrom() : "");
                queueItem.setFromName(this.adhocNotificationService.getServerFromName(AuthenticatedUserThreadLocal.get()));
                if (log.isDebugEnabled()) {
                    log.debug("Sending Mail Queue Item: " + user.getEmail() + "   subject: " + subject);
                }
                this.appfireQueueService.addTask("mail", () -> ((ConfluenceMailQueueItem)queueItem).send());
            }
            if (StringUtils.isNotBlank((CharSequence)address)) {
                if (this.workflowConfigurationManager.isEmailAnyone()) {
                    address = valueStore.replaceReferences(address);
                    String mimeType = this.getMessageMimeType(mimeTypeParam, null);
                    String message = this.getRenderedMessage(mimeType, null, (RenderContext)pageContext, body, MapUtils.getString(parameters, PARAM_FOOTER));
                    Email email = new Email(address);
                    email.setFrom(this.adhocNotificationService.getMailServer().getDefaultFrom());
                    email.setFromName(this.adhocNotificationService.getServerFromName(AuthenticatedUserThreadLocal.get()));
                    email.setSubject(subject);
                    email.setBody(message);
                    email.setMimeType(mimeType);
                    if (log.isDebugEnabled()) {
                        log.debug("Adding email to queue: " + email);
                    }
                    this.appfireQueueService.addTask("mail", () -> ((SingleMailQueueItem)new SingleMailQueueItem(email)).send());
                } else {
                    log.warn("Workflow on page: " + page.getSpaceKey() + ":" + page.getTitle() + " attempted to send email to: " + address + " but global email Anyone configuration is disabled.");
                }
            }
        }
        catch (Exception e) {
            this.logMessage(renderContext, e);
        }
        return "";
    }

    protected String getRenderedMessage(String mimeType, ConfluenceUser toUser, RenderContext pageContext, String emailBody, String emailFooter) {
        String message = null;
        try {
            if ("text/html".equals(mimeType)) {
                String renderedMessage = this.renderMessageBody(pageContext, pageContext.getRenderMode(), emailBody, true);
                Map velocityContext = MacroUtils.defaultVelocityContext();
                velocityContext.put("bodyHtml", renderedMessage);
                velocityContext.put(PARAM_FOOTER, emailFooter);
                message = this.velocityHelperService.getRenderedTemplate("/templates/adhocworkflows/email/send-email-macro.vm", velocityContext);
            } else {
                message = this.renderMessageBodyAsText(pageContext, emailBody);
            }
        }
        catch (WorkflowException we) {
            log.error("Error creating workflow email", (Throwable)we);
        }
        return message;
    }

    protected String getMessageMimeType(String mimeTypeParam, ConfluenceUser user) {
        String mimeType;
        if (StringUtils.isNotBlank((CharSequence)mimeTypeParam)) {
            return mimeTypeParam;
        }
        if (user != null && StringUtils.isNotBlank((CharSequence)(mimeType = this.userAccessor.getUserPreferences((User)user).getString("confluence.prefs.email.mimetype")))) {
            return mimeType;
        }
        return "text/html";
    }

    public static boolean isEmailBody(RenderContext renderContext) {
        return renderContext.getParam((Object)MACRO_NAME) != null;
    }

    public void setGlobalSettingsManager(GlobalSettingsManager globalSettingsManager) {
        this.globalSettingsManager = globalSettingsManager;
    }

    public void setAppfireQueueService(AppfireQueueService appfireQueueService) {
        this.appfireQueueService = appfireQueueService;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setAdhocNotificationService(AdhocNotificationService adhocNotificationService) {
        this.adhocNotificationService = adhocNotificationService;
    }

    @Override
    public void setVelocityHelperService(VelocityHelperService velocityHelperService) {
        this.velocityHelperService = velocityHelperService;
    }
}

