/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners.triggers.attachments;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.manager.EventHistoryManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentEvent;
import com.comalatech.confluence.workflow.listeners.ApprovalPersistanceHandler;
import com.comalatech.confluence.workflow.listeners.triggers.TriggersListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowsAttachmentsTriggersListener
extends TriggersListener {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsAttachmentsTriggersListener.class);
    private final ApprovalPersistanceHandler approvalPersistanceHandler;

    public WorkflowsAttachmentsTriggersListener(WorkflowAccessor workflowAccessor, WorkflowActionManager workflowActionManager, EventPublisher eventPublisher, ApprovalPersistanceHandler approvalPersistanceHandler, EventHistoryManager eventHistoryManager, DarkFeatureManager darkFeatureManager) {
        super(workflowAccessor, workflowActionManager, eventHistoryManager, darkFeatureManager, eventPublisher);
        this.approvalPersistanceHandler = approvalPersistanceHandler;
    }

    @EventListener
    public void onWorkflowAttachmentEvent(WorkflowAttachmentEvent event) {
        this.handleEventTrigger(event);
    }

    @Override
    public void handleEventTrigger(ContentEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)event);
            this.approvalPersistanceHandler.handle((WorkflowAttachmentEvent)event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }
}

